/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.common.ReflectHelpers;

public class SparkRuntimeContext
implements Serializable {
    private final String serializedPipelineOptions;
    private transient CoderRegistry coderRegistry;

    SparkRuntimeContext(Pipeline pipeline, PipelineOptions options) {
        this.serializedPipelineOptions = this.serializePipelineOptions(options);
    }

    private static ObjectMapper createMapper() {
        return new ObjectMapper().registerModules((Iterable)ObjectMapper.findModules((ClassLoader)ReflectHelpers.findClassLoader()));
    }

    private String serializePipelineOptions(PipelineOptions pipelineOptions) {
        try {
            return SparkRuntimeContext.createMapper().writeValueAsString((Object)pipelineOptions);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Failed to serialize the pipeline options.", e);
        }
    }

    private static PipelineOptions deserializePipelineOptions(String serializedPipelineOptions) {
        try {
            return (PipelineOptions)SparkRuntimeContext.createMapper().readValue(serializedPipelineOptions, PipelineOptions.class);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to deserialize the pipeline options.", e);
        }
    }

    public PipelineOptions getPipelineOptions() {
        return PipelineOptionsHolder.getOrInit(this.serializedPipelineOptions);
    }

    public CoderRegistry getCoderRegistry() {
        if (this.coderRegistry == null) {
            this.coderRegistry = CoderRegistry.createDefault();
        }
        return this.coderRegistry;
    }

    private static class PipelineOptionsHolder {
        private static volatile transient PipelineOptions pipelineOptions = null;

        private PipelineOptionsHolder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static PipelineOptions getOrInit(String serializedPipelineOptions) {
            if (pipelineOptions != null) return pipelineOptions;
            Class<PipelineOptionsHolder> clazz = PipelineOptionsHolder.class;
            synchronized (PipelineOptionsHolder.class) {
                if (pipelineOptions == null) {
                    pipelineOptions = SparkRuntimeContext.deserializePipelineOptions(serializedPipelineOptions);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                FileSystems.setDefaultPipelineOptions((PipelineOptions)pipelineOptions);
                return pipelineOptions;
            }
        }
    }
}

