/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataOutput;
import java.io.IOException;
import java.security.MessageDigest;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;

public class EchoedRow
extends AbstractCompactedRow {
    private final SSTableIdentityIterator row;

    public EchoedRow(SSTableIdentityIterator row) {
        super(row.getKey());
        this.row = row;
        row.reset();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        assert (this.row.dataSize > 0L);
        out.writeLong(this.row.dataSize);
        this.row.echoData(out);
    }

    @Override
    public void update(MessageDigest digest) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return !this.row.hasNext();
    }

    @Override
    public int columnCount() {
        return this.row.columnCount;
    }
}

