/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.GossipDigest;
import org.apache.cassandra.gms.GossipDigestAckMessage;
import org.apache.cassandra.gms.GossipDigestSynMessage;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GossipDigestSynVerbHandler
implements IVerbHandler {
    private static Logger logger_ = LoggerFactory.getLogger(GossipDigestSynVerbHandler.class);

    @Override
    public void doVerb(Message message, String id) {
        InetAddress from = message.getFrom();
        if (logger_.isTraceEnabled()) {
            logger_.trace("Received a GossipDigestSynMessage from {}", (Object)from);
        }
        if (!Gossiper.instance.isEnabled()) {
            if (logger_.isTraceEnabled()) {
                logger_.trace("Ignoring GossipDigestSynMessage because gossip is disabled");
            }
            return;
        }
        byte[] bytes = message.getMessageBody();
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            GossipDigestSynMessage gDigestMessage = GossipDigestSynMessage.serializer().deserialize(dis, message.getVersion());
            if (!gDigestMessage.clusterId_.equals(DatabaseDescriptor.getClusterName())) {
                logger_.warn("ClusterName mismatch from " + from + " " + gDigestMessage.clusterId_ + "!=" + DatabaseDescriptor.getClusterName());
                return;
            }
            List<GossipDigest> gDigestList = gDigestMessage.getGossipDigests();
            if (logger_.isTraceEnabled()) {
                StringBuilder sb = new StringBuilder();
                for (GossipDigest gDigest : gDigestList) {
                    sb.append(gDigest);
                    sb.append(" ");
                }
                logger_.trace("Gossip syn digests are : " + sb.toString());
            }
            Gossiper.instance.notifyFailureDetector(gDigestList);
            this.doSort(gDigestList);
            ArrayList<GossipDigest> deltaGossipDigestList = new ArrayList<GossipDigest>();
            HashMap<InetAddress, EndpointState> deltaEpStateMap = new HashMap<InetAddress, EndpointState>();
            Gossiper.instance.examineGossiper(gDigestList, deltaGossipDigestList, deltaEpStateMap);
            GossipDigestAckMessage gDigestAck = new GossipDigestAckMessage(deltaGossipDigestList, deltaEpStateMap);
            Message gDigestAckMessage = Gossiper.instance.makeGossipDigestAckMessage(gDigestAck, message.getVersion());
            if (logger_.isTraceEnabled()) {
                logger_.trace("Sending a GossipDigestAckMessage to {}", (Object)from);
            }
            MessagingService.instance().sendOneWay(gDigestAckMessage, from);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void doSort(List<GossipDigest> gDigestList) {
        HashMap<InetAddress, GossipDigest> epToDigestMap = new HashMap<InetAddress, GossipDigest>();
        for (GossipDigest gDigest : gDigestList) {
            epToDigestMap.put(gDigest.getEndpoint(), gDigest);
        }
        ArrayList<GossipDigest> diffDigests = new ArrayList<GossipDigest>();
        for (GossipDigest gDigest : gDigestList) {
            InetAddress ep = gDigest.getEndpoint();
            EndpointState epState = Gossiper.instance.getEndpointStateForEndpoint(ep);
            int version = epState != null ? Gossiper.instance.getMaxEndpointStateVersion(epState) : 0;
            int diffVersion = Math.abs(version - gDigest.getMaxVersion());
            diffDigests.add(new GossipDigest(ep, gDigest.getGeneration(), diffVersion));
        }
        gDigestList.clear();
        Collections.sort(diffDigests);
        int size = diffDigests.size();
        for (int i = size - 1; i >= 0; --i) {
            gDigestList.add((GossipDigest)epToDigestMap.get(((GossipDigest)diffDigests.get(i)).getEndpoint()));
        }
    }
}

