/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.cassandra.concurrent.IExecutorMBean;

class ThreadPoolProxyMBeanIterator
implements Iterator<Map.Entry<String, IExecutorMBean>> {
    private Iterator<ObjectName> resIter;
    private MBeanServerConnection mbeanServerConn;

    public ThreadPoolProxyMBeanIterator(MBeanServerConnection mbeanServerConn) throws MalformedObjectNameException, NullPointerException, IOException {
        Set<ObjectName> requests = mbeanServerConn.queryNames(new ObjectName("org.apache.cassandra.request:type=*"), null);
        Set<ObjectName> internal = mbeanServerConn.queryNames(new ObjectName("org.apache.cassandra.internal:type=*"), null);
        this.resIter = Iterables.concat(requests, internal).iterator();
        this.mbeanServerConn = mbeanServerConn;
    }

    @Override
    public boolean hasNext() {
        return this.resIter.hasNext();
    }

    @Override
    public Map.Entry<String, IExecutorMBean> next() {
        ObjectName objectName = this.resIter.next();
        String poolName = objectName.getKeyProperty("type");
        IExecutorMBean threadPoolProxy = JMX.newMBeanProxy(this.mbeanServerConn, objectName, IExecutorMBean.class);
        return new AbstractMap.SimpleImmutableEntry<String, IExecutorMBean>(poolName, threadPoolProxy);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

