/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql;

import java.io.IOException;
import java.util.Iterator;
import org.apache.avro.util.Utf8;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.migration.UpdateColumnFamily;
import org.apache.cassandra.db.migration.avro.CfDef;
import org.apache.cassandra.db.migration.avro.ColumnDef;
import org.apache.cassandra.thrift.InvalidRequestException;

public class DropIndexStatement {
    public final CharSequence index;

    public DropIndexStatement(String indexName) {
        this.index = new Utf8(indexName);
    }

    public UpdateColumnFamily generateMutation(String keyspace) throws InvalidRequestException, ConfigurationException, IOException {
        CFMetaData cfm;
        CfDef cfDef = null;
        KSMetaData ksm = Schema.instance.getTableDefinition(keyspace);
        Iterator<CFMetaData> i$ = ksm.cfMetaData().values().iterator();
        while (i$.hasNext() && (cfDef = this.getUpdatedCFDef((cfm = i$.next()).toAvro())) == null) {
        }
        if (cfDef == null) {
            throw new InvalidRequestException("Index '" + this.index + "' could not be found in any of the ColumnFamilies of keyspace '" + keyspace + "'");
        }
        return new UpdateColumnFamily(cfDef);
    }

    private CfDef getUpdatedCFDef(CfDef cfDef) throws InvalidRequestException {
        for (ColumnDef column : cfDef.column_metadata) {
            if (column.index_type == null || column.index_name == null || !column.index_name.equals(this.index)) continue;
            column.index_name = null;
            column.index_type = null;
            return cfDef;
        }
        return null;
    }
}

