/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.columniterator;

import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.columniterator.IColumnIterator;
import org.apache.cassandra.db.columniterator.IndexedSliceReader;
import org.apache.cassandra.db.columniterator.SimpleSliceReader;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.utils.ByteBufferUtil;

public class SSTableSliceIterator
implements IColumnIterator {
    private final FileDataInput fileToClose;
    private IColumnIterator reader;
    private DecoratedKey key;

    public SSTableSliceIterator(SSTableReader sstable, DecoratedKey key, ByteBuffer startColumn, ByteBuffer finishColumn, boolean reversed) {
        this.key = key;
        this.fileToClose = sstable.getFileDataInput(this.key, DatabaseDescriptor.getSlicedReadBufferSizeInKB() * 1024);
        if (this.fileToClose == null) {
            return;
        }
        try {
            DecoratedKey keyInDisk = SSTableReader.decodeKey(sstable.partitioner, sstable.descriptor, ByteBufferUtil.readWithShortLength(this.fileToClose));
            assert (keyInDisk.equals(key)) : String.format("%s != %s in %s", keyInDisk, key, this.fileToClose.getPath());
            SSTableReader.readRowSize(this.fileToClose, sstable.descriptor);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        this.reader = SSTableSliceIterator.createReader(sstable, this.fileToClose, startColumn, finishColumn, reversed);
    }

    public SSTableSliceIterator(SSTableReader sstable, FileDataInput file, DecoratedKey key, ByteBuffer startColumn, ByteBuffer finishColumn, boolean reversed) {
        this.key = key;
        this.fileToClose = null;
        this.reader = SSTableSliceIterator.createReader(sstable, file, startColumn, finishColumn, reversed);
    }

    private static IColumnIterator createReader(SSTableReader sstable, FileDataInput file, ByteBuffer startColumn, ByteBuffer finishColumn, boolean reversed) {
        return startColumn.remaining() == 0 && !reversed ? new SimpleSliceReader(sstable, file, finishColumn) : new IndexedSliceReader(sstable, file, startColumn, finishColumn, reversed);
    }

    @Override
    public DecoratedKey getKey() {
        return this.key;
    }

    @Override
    public ColumnFamily getColumnFamily() {
        return this.reader == null ? null : this.reader.getColumnFamily();
    }

    @Override
    public boolean hasNext() {
        return this.reader != null && this.reader.hasNext();
    }

    @Override
    public IColumn next() {
        return (IColumn)this.reader.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        if (this.fileToClose != null) {
            this.fileToClose.close();
        }
    }
}

