/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.utils.Pair;

public abstract class AbstractBounds
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static AbstractBoundsSerializer serializer = new AbstractBoundsSerializer();
    public final Token left;
    public final Token right;
    protected final transient IPartitioner partitioner;

    public static AbstractBoundsSerializer serializer() {
        return serializer;
    }

    public AbstractBounds(Token left, Token right, IPartitioner partitioner) {
        this.left = left;
        this.right = right;
        this.partitioner = partitioner;
    }

    public Pair<AbstractBounds, AbstractBounds> split(Token token) {
        assert (this.left.equals(token) || this.contains(token));
        AbstractBounds lb = this.createFrom(token);
        Range rb = lb != null && token.equals(this.right) ? null : new Range(token, this.right);
        return new Pair<AbstractBounds, AbstractBounds>(lb, rb);
    }

    public int hashCode() {
        return 31 * this.left.hashCode() + this.right.hashCode();
    }

    public abstract boolean equals(Object var1);

    public abstract boolean contains(Token var1);

    public abstract AbstractBounds createFrom(Token var1);

    public abstract List<AbstractBounds> unwrap();

    public static List<AbstractBounds> normalize(Collection<? extends AbstractBounds> bounds) {
        ArrayList<AbstractBounds> output = new ArrayList<AbstractBounds>();
        for (AbstractBounds abstractBounds : bounds) {
            output.addAll(abstractBounds.unwrap());
        }
        Collections.sort(output, new Comparator<AbstractBounds>(){

            @Override
            public int compare(AbstractBounds b1, AbstractBounds b2) {
                return b1.left.compareTo(b2.left);
            }
        });
        return AbstractBounds.deoverlap(output);
    }

    private static List<AbstractBounds> deoverlap(List<AbstractBounds> bounds) {
        if (bounds.isEmpty()) {
            return bounds;
        }
        ArrayList<AbstractBounds> output = new ArrayList<AbstractBounds>();
        Iterator<AbstractBounds> iter = bounds.iterator();
        AbstractBounds current = iter.next();
        boolean isRange = current instanceof Range;
        Object min = current.partitioner.getMinimumToken();
        while (iter.hasNext()) {
            if (current.right.equals(min)) {
                if (current.left.equals(min)) {
                    return Collections.singletonList(current);
                }
                output.add(current.createFrom((Token)min));
                return output;
            }
            AbstractBounds next = iter.next();
            assert (!isRange ? next instanceof Bounds : next instanceof Range);
            if (next.left.compareTo(current.right) <= 0) {
                Token newRight = next.right.equals(min) || current.right.compareTo(next.right) < 0 ? next.right : current.right;
                if ((current = current.createFrom(newRight)) != null) continue;
                return Collections.singletonList(new Range((Token)min, (Token)min));
            }
            output.add(current);
            current = next;
        }
        output.add(current);
        return output;
    }

    public static class AbstractBoundsSerializer
    implements ISerializer<AbstractBounds> {
        @Override
        public void serialize(AbstractBounds range, DataOutput out) throws IOException {
            out.writeInt(range instanceof Range ? Type.RANGE.ordinal() : Type.BOUNDS.ordinal());
            Token.serializer().serialize(range.left, out);
            Token.serializer().serialize(range.right, out);
        }

        @Override
        public AbstractBounds deserialize(DataInput in) throws IOException {
            if (in.readInt() == Type.RANGE.ordinal()) {
                return new Range(Token.serializer().deserialize(in), Token.serializer().deserialize(in));
            }
            return new Bounds(Token.serializer().deserialize(in), Token.serializer().deserialize(in));
        }

        @Override
        public long serializedSize(AbstractBounds abstractBounds) {
            throw new UnsupportedOperationException();
        }
    }

    private static enum Type {
        RANGE,
        BOUNDS;

    }
}

