/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.net.InetAddress;
import org.apache.cassandra.gms.GossipDigestSerializer;
import org.apache.cassandra.io.IVersionedSerializer;

public class GossipDigest
implements Comparable<GossipDigest> {
    private static IVersionedSerializer<GossipDigest> serializer = new GossipDigestSerializer();
    InetAddress endpoint;
    int generation;
    int maxVersion;

    public static IVersionedSerializer<GossipDigest> serializer() {
        return serializer;
    }

    GossipDigest(InetAddress ep, int gen, int version) {
        this.endpoint = ep;
        this.generation = gen;
        this.maxVersion = version;
    }

    InetAddress getEndpoint() {
        return this.endpoint;
    }

    int getGeneration() {
        return this.generation;
    }

    int getMaxVersion() {
        return this.maxVersion;
    }

    @Override
    public int compareTo(GossipDigest gDigest) {
        if (this.generation != gDigest.generation) {
            return this.generation - gDigest.generation;
        }
        return this.maxVersion - gDigest.maxVersion;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.endpoint);
        sb.append(":");
        sb.append(this.generation);
        sb.append(":");
        sb.append(this.maxVersion);
        return sb.toString();
    }
}

