/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.apache.cassandra.thrift.TCustomSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCustomServerSocket
extends TServerTransport {
    private static final Logger logger = LoggerFactory.getLogger(TCustomServerSocket.class);
    private ServerSocket serverSocket_ = null;
    private final boolean keepAlive;
    private final Integer sendBufferSize;
    private final Integer recvBufferSize;

    public TCustomServerSocket(InetSocketAddress bindAddr, boolean keepAlive, Integer sendBufferSize, Integer recvBufferSize) throws TTransportException {
        try {
            this.serverSocket_ = new ServerSocket();
            this.serverSocket_.setReuseAddress(true);
            this.serverSocket_.bind(bindAddr);
        }
        catch (IOException ioe) {
            this.serverSocket_ = null;
            throw new TTransportException("Could not create ServerSocket on address " + bindAddr.toString() + ".");
        }
        this.keepAlive = keepAlive;
        this.sendBufferSize = sendBufferSize;
        this.recvBufferSize = recvBufferSize;
    }

    protected TCustomSocket acceptImpl() throws TTransportException {
        if (this.serverSocket_ == null) {
            throw new TTransportException(1, "No underlying server socket.");
        }
        TCustomSocket tsocket = null;
        Socket socket = null;
        try {
            socket = this.serverSocket_.accept();
            tsocket = new TCustomSocket(socket);
            tsocket.setTimeout(0);
        }
        catch (IOException iox) {
            throw new TTransportException((Throwable)iox);
        }
        try {
            socket.setKeepAlive(this.keepAlive);
        }
        catch (SocketException se) {
            logger.warn("Failed to set keep-alive on Thrift socket.", (Throwable)se);
        }
        if (this.sendBufferSize != null) {
            try {
                socket.setSendBufferSize(this.sendBufferSize);
            }
            catch (SocketException se) {
                logger.warn("Failed to set send buffer size on Thrift socket.", (Throwable)se);
            }
        }
        if (this.recvBufferSize != null) {
            try {
                socket.setReceiveBufferSize(this.recvBufferSize);
            }
            catch (SocketException se) {
                logger.warn("Failed to set receive buffer size on Thrift socket.", (Throwable)se);
            }
        }
        return tsocket;
    }

    public void listen() throws TTransportException {
        if (this.serverSocket_ != null) {
            try {
                this.serverSocket_.setSoTimeout(0);
            }
            catch (SocketException sx) {
                logger.error("Could not set socket timeout.", (Throwable)sx);
            }
        }
    }

    public void close() {
        if (this.serverSocket_ != null) {
            try {
                this.serverSocket_.close();
            }
            catch (IOException iox) {
                logger.warn("Could not close server socket.", (Throwable)iox);
            }
            this.serverSocket_ = null;
        }
    }

    public void interrupt() {
        this.close();
    }
}

