/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import java.nio.ByteBuffer;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.selection.Selection;
import org.apache.cassandra.cql3.selection.SelectionColumnMapping;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;

public final class SimpleSelector
extends Selector {
    private final String columnName;
    private final int idx;
    private final AbstractType<?> type;
    private ByteBuffer current;
    private boolean isSet;

    public static Selector.Factory newFactory(final ColumnDefinition def, final int idx) {
        return new Selector.Factory(){

            @Override
            protected String getColumnName() {
                return def.name.toString();
            }

            @Override
            protected AbstractType<?> getReturnType() {
                return def.type;
            }

            @Override
            protected void addColumnMapping(SelectionColumnMapping mapping, ColumnSpecification resultColumn) {
                mapping.addMapping(resultColumn, def);
            }

            @Override
            public Selector newInstance() {
                return new SimpleSelector(def.name.toString(), idx, def.type);
            }
        };
    }

    @Override
    public void addInput(int protocolVersion, Selection.ResultSetBuilder rs) throws InvalidRequestException {
        if (!this.isSet) {
            this.isSet = true;
            this.current = rs.current.get(this.idx);
        }
    }

    @Override
    public ByteBuffer getOutput(int protocolVersion) throws InvalidRequestException {
        return this.current;
    }

    @Override
    public void reset() {
        this.isSet = false;
        this.current = null;
    }

    @Override
    public AbstractType<?> getType() {
        return this.type;
    }

    public String toString() {
        return this.columnName;
    }

    private SimpleSelector(String columnName, int idx, AbstractType<?> type) {
        this.columnName = columnName;
        this.idx = idx;
        this.type = type;
    }
}

