/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.composites;

import java.nio.ByteBuffer;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.composites.AbstractComposite;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.memory.AbstractAllocator;

public class SimpleComposite
extends AbstractComposite {
    private static final long EMPTY_SIZE = ObjectSizes.measure(new SimpleComposite(ByteBuffer.allocate(1)));
    protected final ByteBuffer element;

    SimpleComposite(ByteBuffer element) {
        assert (element.hasRemaining());
        this.element = element;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public ByteBuffer get(int i) {
        if (i != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.element;
    }

    @Override
    public Composite withEOC(Composite.EOC newEoc) {
        return this;
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return this.element;
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE + ObjectSizes.sizeOnHeapOf(this.element);
    }

    @Override
    public Composite copy(CFMetaData cfm, AbstractAllocator allocator) {
        return new SimpleComposite(allocator.clone(this.element));
    }
}

