/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.big;

import java.io.DataInput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.AbstractCell;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnIndex;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.CounterCell;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.compress.CompressedSequentialWriter;
import org.apache.cassandra.io.sstable.ColumnNameHelper;
import org.apache.cassandra.io.sstable.ColumnStats;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.IndexSummary;
import org.apache.cassandra.io.sstable.IndexSummaryBuilder;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.io.sstable.metadata.MetadataComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.io.util.BufferedDataOutputStreamPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.FileMark;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.SegmentedFile;
import org.apache.cassandra.io.util.SequentialWriter;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FilterFactory;
import org.apache.cassandra.utils.IFilter;
import org.apache.cassandra.utils.StreamingHistogram;
import org.apache.cassandra.utils.SyncUtil;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.concurrent.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigTableWriter
extends SSTableWriter {
    private static final Logger logger = LoggerFactory.getLogger(BigTableWriter.class);
    public static final int END_OF_ROW = 0;
    private final IndexWriter iwriter;
    private SegmentedFile.Builder dbuilder;
    private final SequentialWriter dataFile;
    private DecoratedKey lastWrittenKey;
    private FileMark dataMark;

    BigTableWriter(Descriptor descriptor, Long keyCount, Long repairedAt, CFMetaData metadata, IPartitioner partitioner, MetadataCollector metadataCollector) {
        super(descriptor, keyCount, repairedAt, metadata, partitioner, metadataCollector);
        if (this.compression) {
            this.dataFile = SequentialWriter.open(this.getFilename(), descriptor.filenameFor(Component.COMPRESSION_INFO), metadata.compressionParameters(), metadataCollector);
            this.dbuilder = SegmentedFile.getCompressedBuilder((CompressedSequentialWriter)this.dataFile);
        } else {
            this.dataFile = SequentialWriter.open(new File(this.getFilename()), new File(descriptor.filenameFor(Component.CRC)));
            this.dbuilder = SegmentedFile.getBuilder(DatabaseDescriptor.getDiskAccessMode(), false);
        }
        this.iwriter = new IndexWriter(keyCount, this.dataFile);
    }

    @Override
    public void mark() {
        this.dataMark = this.dataFile.mark();
        this.iwriter.mark();
    }

    @Override
    public void resetAndTruncate() {
        this.dataFile.resetAndTruncate(this.dataMark);
        this.iwriter.resetAndTruncate();
    }

    private long beforeAppend(DecoratedKey decoratedKey) {
        assert (decoratedKey != null) : "Keys must not be null";
        if (this.lastWrittenKey != null && this.lastWrittenKey.compareTo(decoratedKey) >= 0) {
            throw new RuntimeException("Last written key " + this.lastWrittenKey + " >= current key " + decoratedKey + " writing into " + this.getFilename());
        }
        return this.lastWrittenKey == null ? 0L : this.dataFile.getFilePointer();
    }

    private void afterAppend(DecoratedKey decoratedKey, long dataEnd, RowIndexEntry index) throws IOException {
        this.metadataCollector.addKey(decoratedKey.getKey());
        this.last = this.lastWrittenKey = decoratedKey;
        if (this.first == null) {
            this.first = this.lastWrittenKey;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("wrote {} at {}", (Object)decoratedKey, (Object)dataEnd);
        }
        this.iwriter.append(decoratedKey, index, dataEnd);
        this.dbuilder.addPotentialBoundary(dataEnd);
    }

    @Override
    public RowIndexEntry append(AbstractCompactedRow row) {
        long startPosition = this.beforeAppend(row.key);
        try {
            RowIndexEntry entry = row.write(startPosition, this.dataFile);
            if (entry == null) {
                return null;
            }
            long endPosition = this.dataFile.getFilePointer();
            long rowSize = endPosition - startPosition;
            this.maybeLogLargePartitionWarning(row.key, rowSize);
            this.metadataCollector.update(rowSize, row.columnStats());
            this.afterAppend(row.key, endPosition, entry);
            return entry;
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.dataFile.getPath());
        }
    }

    @Override
    public void append(DecoratedKey decoratedKey, ColumnFamily cf) {
        long endPosition;
        if (decoratedKey.getKey().remaining() > 65535) {
            logger.error("Key size {} exceeds maximum of {}, skipping row", (Object)decoratedKey.getKey().remaining(), (Object)65535);
            return;
        }
        long startPosition = this.beforeAppend(decoratedKey);
        try {
            RowIndexEntry entry = BigTableWriter.rawAppend(cf, startPosition, decoratedKey, this.dataFile.stream);
            endPosition = this.dataFile.getFilePointer();
            this.afterAppend(decoratedKey, endPosition, entry);
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.dataFile.getPath());
        }
        long rowSize = endPosition - startPosition;
        this.maybeLogLargePartitionWarning(decoratedKey, rowSize);
        this.metadataCollector.update(endPosition - startPosition, cf.getColumnStats());
    }

    private void maybeLogLargePartitionWarning(DecoratedKey key, long rowSize) {
        if (rowSize > (long)DatabaseDescriptor.getCompactionLargePartitionWarningThreshold()) {
            String keyString = this.metadata.getKeyValidator().getString(key.getKey());
            logger.warn("Writing large partition {}/{}:{} ({} bytes)", new Object[]{this.metadata.ksName, this.metadata.cfName, keyString, rowSize});
        }
    }

    private static RowIndexEntry rawAppend(ColumnFamily cf, long startPosition, DecoratedKey key, DataOutputPlus out) throws IOException {
        assert (cf.hasColumns() || cf.isMarkedForDelete());
        ColumnIndex.Builder builder = new ColumnIndex.Builder(cf, key.getKey(), out);
        ColumnIndex index = builder.build(cf);
        out.writeShort(0);
        return RowIndexEntry.create(startPosition, cf.deletionInfo().getTopLevelDeletion(), index);
    }

    @Override
    public long appendFromStream(DecoratedKey key, CFMetaData metadata, DataInput in, Version version) throws IOException {
        long currentPosition = this.beforeAppend(key);
        ColumnStats.MaxLongTracker maxTimestampTracker = new ColumnStats.MaxLongTracker(Long.MAX_VALUE);
        ColumnStats.MinLongTracker minTimestampTracker = new ColumnStats.MinLongTracker(Long.MIN_VALUE);
        ColumnStats.MaxIntTracker maxDeletionTimeTracker = new ColumnStats.MaxIntTracker(Integer.MAX_VALUE);
        List<ByteBuffer> minColumnNames = Collections.emptyList();
        List<ByteBuffer> maxColumnNames = Collections.emptyList();
        StreamingHistogram tombstones = new StreamingHistogram(100);
        boolean hasLegacyCounterShards = false;
        ArrayBackedSortedColumns cf = ArrayBackedSortedColumns.factory.create(metadata);
        ((ColumnFamily)cf).delete(DeletionTime.serializer.deserialize(in));
        ColumnIndex.Builder columnIndexer = new ColumnIndex.Builder(cf, key.getKey(), this.dataFile.stream);
        if (((ColumnFamily)cf).deletionInfo().getTopLevelDeletion().localDeletionTime < Integer.MAX_VALUE) {
            tombstones.update(((ColumnFamily)cf).deletionInfo().getTopLevelDeletion().localDeletionTime);
            maxDeletionTimeTracker.update(((ColumnFamily)cf).deletionInfo().getTopLevelDeletion().localDeletionTime);
            minTimestampTracker.update(((ColumnFamily)cf).deletionInfo().getTopLevelDeletion().markedForDeleteAt);
            maxTimestampTracker.update(((ColumnFamily)cf).deletionInfo().getTopLevelDeletion().markedForDeleteAt);
        }
        Iterator<RangeTombstone> rangeTombstoneIterator = ((ColumnFamily)cf).deletionInfo().rangeIterator();
        while (rangeTombstoneIterator.hasNext()) {
            RangeTombstone rangeTombstone = rangeTombstoneIterator.next();
            tombstones.update(rangeTombstone.getLocalDeletionTime());
            minTimestampTracker.update(rangeTombstone.timestamp());
            maxTimestampTracker.update(rangeTombstone.timestamp());
            maxDeletionTimeTracker.update(rangeTombstone.getLocalDeletionTime());
            minColumnNames = ColumnNameHelper.minComponents(minColumnNames, (Composite)rangeTombstone.min, metadata.comparator);
            maxColumnNames = ColumnNameHelper.maxComponents(maxColumnNames, (Composite)rangeTombstone.max, metadata.comparator);
        }
        Iterator<OnDiskAtom> iter = AbstractCell.onDiskIterator(in, ColumnSerializer.Flag.PRESERVE_SIZE, Integer.MIN_VALUE, version, metadata.comparator);
        try {
            OnDiskAtom atom;
            while (iter.hasNext() && (atom = iter.next()) != null) {
                int deletionTime;
                if (atom instanceof CounterCell) {
                    atom = ((CounterCell)atom).markLocalToBeCleared();
                    boolean bl = hasLegacyCounterShards = hasLegacyCounterShards || ((CounterCell)atom).hasLegacyShards();
                }
                if ((deletionTime = atom.getLocalDeletionTime()) < Integer.MAX_VALUE) {
                    tombstones.update(deletionTime);
                }
                minTimestampTracker.update(atom.timestamp());
                maxTimestampTracker.update(atom.timestamp());
                minColumnNames = ColumnNameHelper.minComponents(minColumnNames, atom.name(), metadata.comparator);
                maxColumnNames = ColumnNameHelper.maxComponents(maxColumnNames, atom.name(), metadata.comparator);
                maxDeletionTimeTracker.update(atom.getLocalDeletionTime());
                columnIndexer.add(atom);
            }
            columnIndexer.maybeWriteEmptyRowHeader();
            this.dataFile.stream.writeShort(0);
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.dataFile.getPath());
        }
        this.metadataCollector.updateMinTimestamp(minTimestampTracker.get()).updateMaxTimestamp(maxTimestampTracker.get()).updateMaxLocalDeletionTime(maxDeletionTimeTracker.get()).addRowSize(this.dataFile.getFilePointer() - currentPosition).addColumnCount(columnIndexer.writtenAtomCount()).mergeTombstoneHistogram(tombstones).updateMinColumnNames(minColumnNames).updateMaxColumnNames(maxColumnNames).updateHasLegacyCounterShards(hasLegacyCounterShards);
        this.afterAppend(key, currentPosition, RowIndexEntry.create(currentPosition, ((ColumnFamily)cf).deletionInfo().getTopLevelDeletion(), columnIndexer.build()));
        return currentPosition;
    }

    private Descriptor makeTmpLinks() {
        Descriptor link = this.descriptor.asType(Descriptor.Type.TEMPLINK);
        if (!new File(link.filenameFor(Component.PRIMARY_INDEX)).exists()) {
            FileUtils.createHardLink(new File(this.descriptor.filenameFor(Component.PRIMARY_INDEX)), new File(link.filenameFor(Component.PRIMARY_INDEX)));
            FileUtils.createHardLink(new File(this.descriptor.filenameFor(Component.DATA)), new File(link.filenameFor(Component.DATA)));
        }
        return link;
    }

    @Override
    public SSTableReader openEarly() {
        IndexSummaryBuilder.ReadableBoundary boundary = this.iwriter.getMaxReadable();
        if (boundary == null) {
            return null;
        }
        StatsMetadata stats = this.statsMetadata();
        assert (boundary.indexLength > 0L && boundary.dataLength > 0L);
        Descriptor link = this.makeTmpLinks();
        SegmentedFile ifile = this.iwriter.builder.complete(link.filenameFor(Component.PRIMARY_INDEX), boundary.indexLength);
        SegmentedFile dfile = this.dbuilder.complete(link.filenameFor(Component.DATA), boundary.dataLength);
        SSTableReader sstable = SSTableReader.internalOpen(this.descriptor.asType(Descriptor.Type.FINAL), this.components, this.metadata, this.partitioner, ifile, dfile, this.iwriter.summary.build(this.partitioner, boundary), this.iwriter.bf.sharedCopy(), this.maxDataAge, stats, SSTableReader.OpenReason.EARLY);
        sstable.first = BigTableWriter.getMinimalKey(this.first);
        sstable.last = BigTableWriter.getMinimalKey(boundary.lastKey);
        return sstable;
    }

    @Override
    public SSTableReader openFinalEarly() {
        this.dataFile.sync();
        this.iwriter.indexFile.sync();
        return this.openFinal(this.makeTmpLinks(), SSTableReader.OpenReason.EARLY);
    }

    private SSTableReader openFinal(Descriptor desc, SSTableReader.OpenReason openReason) {
        if (this.maxDataAge < 0L) {
            this.maxDataAge = System.currentTimeMillis();
        }
        StatsMetadata stats = this.statsMetadata();
        SegmentedFile ifile = this.iwriter.builder.complete(desc.filenameFor(Component.PRIMARY_INDEX));
        SegmentedFile dfile = this.dbuilder.complete(desc.filenameFor(Component.DATA));
        SSTableReader sstable = SSTableReader.internalOpen(desc.asType(Descriptor.Type.FINAL), this.components, this.metadata, this.partitioner, ifile, dfile, this.iwriter.summary.build(this.partitioner), this.iwriter.bf.sharedCopy(), this.maxDataAge, stats, openReason);
        sstable.first = BigTableWriter.getMinimalKey(this.first);
        sstable.last = BigTableWriter.getMinimalKey(this.last);
        return sstable;
    }

    @Override
    protected SSTableWriter.TransactionalProxy txnProxy() {
        return new TransactionalProxy();
    }

    private static void writeMetadata(Descriptor desc, Map<MetadataType, MetadataComponent> components) {
        File file = new File(desc.filenameFor(Component.STATS));
        try (SequentialWriter out = SequentialWriter.open(file);){
            desc.getMetadataSerializer().serialize(components, out.stream);
            out.setDescriptor(desc).finish();
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, file.getPath());
        }
    }

    @Override
    public long getFilePointer() {
        return this.dataFile.getFilePointer();
    }

    @Override
    public long getOnDiskFilePointer() {
        return this.dataFile.getOnDiskFilePointer();
    }

    class IndexWriter
    extends Transactional.AbstractTransactional
    implements Transactional {
        private final SequentialWriter indexFile;
        public final SegmentedFile.Builder builder;
        public final IndexSummaryBuilder summary;
        public final IFilter bf;
        private FileMark mark;

        IndexWriter(long keyCount, final SequentialWriter dataFile) {
            this.indexFile = SequentialWriter.open(new File(BigTableWriter.this.descriptor.filenameFor(Component.PRIMARY_INDEX)));
            this.builder = SegmentedFile.getBuilder(DatabaseDescriptor.getIndexAccessMode(), false);
            this.summary = new IndexSummaryBuilder(keyCount, BigTableWriter.this.metadata.getMinIndexInterval(), 128);
            this.bf = FilterFactory.getFilter(keyCount, BigTableWriter.this.metadata.getBloomFilterFpChance(), true);
            this.indexFile.setPostFlushListener(new Runnable(){

                @Override
                public void run() {
                    IndexWriter.this.summary.markIndexSynced(IndexWriter.this.indexFile.getLastFlushOffset());
                }
            });
            dataFile.setPostFlushListener(new Runnable(){

                @Override
                public void run() {
                    IndexWriter.this.summary.markDataSynced(dataFile.getLastFlushOffset());
                }
            });
        }

        IndexSummaryBuilder.ReadableBoundary getMaxReadable() {
            return this.summary.getLastReadableBoundary();
        }

        public void append(DecoratedKey key, RowIndexEntry indexEntry, long dataEnd) throws IOException {
            this.bf.add(key);
            long indexStart = this.indexFile.getFilePointer();
            try {
                ByteBufferUtil.writeWithShortLength(key.getKey(), this.indexFile.stream);
                BigTableWriter.this.rowIndexEntrySerializer.serialize(indexEntry, this.indexFile.stream);
            }
            catch (IOException e) {
                throw new FSWriteError((Throwable)e, this.indexFile.getPath());
            }
            long indexEnd = this.indexFile.getFilePointer();
            if (logger.isTraceEnabled()) {
                logger.trace("wrote index entry: {} at {}", (Object)indexEntry, (Object)indexStart);
            }
            this.summary.maybeAddEntry(key, indexStart, indexEnd, dataEnd);
            this.builder.addPotentialBoundary(indexStart);
        }

        void flushBf() {
            if (BigTableWriter.this.components.contains(Component.FILTER)) {
                String path = BigTableWriter.this.descriptor.filenameFor(Component.FILTER);
                try (FileOutputStream fos = new FileOutputStream(path);
                     BufferedDataOutputStreamPlus stream = new BufferedDataOutputStreamPlus(fos);){
                    FilterFactory.serialize(this.bf, stream);
                    ((OutputStream)stream).flush();
                    SyncUtil.sync(fos);
                }
                catch (IOException e) {
                    throw new FSWriteError((Throwable)e, path);
                }
            }
        }

        public void mark() {
            this.mark = this.indexFile.mark();
        }

        public void resetAndTruncate() {
            this.indexFile.resetAndTruncate(this.mark);
        }

        @Override
        protected void doPrepare() {
            this.flushBf();
            long position = ((BigTableWriter)BigTableWriter.this).iwriter.indexFile.getFilePointer();
            ((BigTableWriter)BigTableWriter.this).iwriter.indexFile.setDescriptor(BigTableWriter.this.descriptor).prepareToCommit();
            FileUtils.truncate(((BigTableWriter)BigTableWriter.this).iwriter.indexFile.getPath(), position);
            this.summary.prepareToCommit();
            try (IndexSummary summary = ((BigTableWriter)BigTableWriter.this).iwriter.summary.build(BigTableWriter.this.partitioner);){
                SSTableReader.saveSummary(BigTableWriter.this.descriptor, BigTableWriter.this.first, BigTableWriter.this.last, ((BigTableWriter)BigTableWriter.this).iwriter.builder, BigTableWriter.this.dbuilder, summary);
            }
        }

        @Override
        protected Throwable doCommit(Throwable accumulate) {
            return this.indexFile.commit(accumulate);
        }

        @Override
        protected Throwable doAbort(Throwable accumulate) {
            return this.indexFile.abort(accumulate);
        }

        @Override
        protected Throwable doPreCleanup(Throwable accumulate) {
            accumulate = this.summary.close(accumulate);
            accumulate = this.bf.close(accumulate);
            accumulate = this.builder.close(accumulate);
            return accumulate;
        }
    }

    class TransactionalProxy
    extends SSTableWriter.TransactionalProxy {
        TransactionalProxy() {
        }

        @Override
        protected void doPrepare() {
            Map metadataComponents = BigTableWriter.this.finalizeMetadata();
            BigTableWriter.this.iwriter.prepareToCommit();
            BigTableWriter.this.dataFile.setDescriptor(BigTableWriter.this.descriptor).prepareToCommit();
            BigTableWriter.writeMetadata(BigTableWriter.this.descriptor, metadataComponents);
            BigTableWriter.appendTOC(BigTableWriter.this.descriptor, BigTableWriter.this.components);
            SSTableWriter.rename(BigTableWriter.this.descriptor, BigTableWriter.this.components);
            if (this.openResult) {
                this.finalReader = BigTableWriter.this.openFinal(BigTableWriter.this.descriptor.asType(Descriptor.Type.FINAL), SSTableReader.OpenReason.NORMAL);
            }
        }

        @Override
        protected Throwable doCommit(Throwable accumulate) {
            accumulate = BigTableWriter.this.dataFile.commit(accumulate);
            accumulate = BigTableWriter.this.iwriter.commit(accumulate);
            return accumulate;
        }

        @Override
        protected Throwable doPreCleanup(Throwable accumulate) {
            accumulate = BigTableWriter.this.dbuilder.close(accumulate);
            return accumulate;
        }

        @Override
        protected Throwable doAbort(Throwable accumulate) {
            accumulate = BigTableWriter.this.iwriter.abort(accumulate);
            accumulate = BigTableWriter.this.dataFile.abort(accumulate);
            accumulate = this.delete(BigTableWriter.this.descriptor, accumulate);
            if (!this.openResult) {
                accumulate = this.delete(BigTableWriter.this.descriptor.asType(Descriptor.Type.FINAL), accumulate);
            }
            return accumulate;
        }

        private Throwable delete(Descriptor desc, Throwable accumulate) {
            try {
                Set<Component> components = SSTable.discoverComponentsFor(desc);
                if (!components.isEmpty()) {
                    SSTable.delete(desc, components);
                }
            }
            catch (Throwable t) {
                logger.error(String.format("Failed deleting temp components for %s", BigTableWriter.this.descriptor), t);
                accumulate = Throwables.merge(accumulate, t);
            }
            return accumulate;
        }
    }
}

