/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.util.ArrayList;
import java.util.List;

public class ClientWarn {
    private static final String TRUNCATED = " [truncated]";
    private static final ThreadLocal<ClientWarn> warnLocal = new ThreadLocal();
    private final List<String> warnings = new ArrayList<String>();

    private ClientWarn() {
    }

    public static void warn(String text) {
        ClientWarn warner = warnLocal.get();
        if (warner != null) {
            warner.add(text);
        }
    }

    private void add(String warning) {
        if (this.warnings.size() < 65535) {
            this.warnings.add(ClientWarn.maybeTruncate(warning));
        }
    }

    private static String maybeTruncate(String warning) {
        return warning.length() > 65535 ? warning.substring(0, 65535 - TRUNCATED.length()) + TRUNCATED : warning;
    }

    public static void captureWarnings() {
        warnLocal.set(new ClientWarn());
    }

    public static List<String> getWarnings() {
        ClientWarn warner = warnLocal.get();
        if (warner == null || warner.warnings.isEmpty()) {
            return null;
        }
        return warner.warnings;
    }

    public static void resetWarnings() {
        warnLocal.remove();
    }
}

