/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.pager;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.SliceByNamesReadCommand;
import org.apache.cassandra.db.filter.ColumnCounter;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.pager.PagingState;
import org.apache.cassandra.service.pager.SinglePartitionPager;

public class NamesQueryPager
implements SinglePartitionPager {
    private final SliceByNamesReadCommand command;
    private final ConsistencyLevel consistencyLevel;
    private final ClientState state;
    private final boolean localQuery;
    private volatile boolean queried;

    NamesQueryPager(SliceByNamesReadCommand command, ConsistencyLevel consistencyLevel, ClientState state, boolean localQuery) {
        this.command = command;
        this.consistencyLevel = consistencyLevel;
        this.state = state;
        this.localQuery = localQuery;
    }

    @Override
    public ByteBuffer key() {
        return this.command.key;
    }

    @Override
    public ColumnCounter columnCounter() {
        return this.command.filter.columnCounter(null, this.command.timestamp);
    }

    @Override
    public PagingState state() {
        return null;
    }

    @Override
    public boolean isExhausted() {
        return this.queried;
    }

    @Override
    public List<Row> fetchPage(int pageSize) throws RequestValidationException, RequestExecutionException {
        assert (this.command.filter.countCQL3Rows() || this.command.filter.columns.size() <= pageSize);
        if (this.isExhausted()) {
            return Collections.emptyList();
        }
        this.queried = true;
        return this.localQuery ? Collections.singletonList(this.command.getRow(Keyspace.open(this.command.ksName))) : StorageProxy.read(Collections.singletonList(this.command), this.consistencyLevel, this.state);
    }

    @Override
    public int maxRemaining() {
        if (this.queried) {
            return 0;
        }
        return this.command.filter.countCQL3Rows() ? 1 : this.command.filter.columns.size();
    }

    public long timestamp() {
        return this.command.timestamp;
    }
}

