/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Objects;
import org.apache.commons.beanutils2.DynaBean;
import org.apache.commons.beanutils2.JDBCDynaClass;
import org.apache.commons.beanutils2.ResultSetIterator;

public class ResultSetDynaClass
extends JDBCDynaClass {
    private static final long serialVersionUID = 1L;
    protected ResultSet resultSet = null;

    public ResultSetDynaClass(ResultSet resultSet) throws SQLException {
        this(resultSet, true);
    }

    public ResultSetDynaClass(ResultSet resultSet, boolean lowerCase) throws SQLException {
        this(resultSet, lowerCase, false);
    }

    public ResultSetDynaClass(ResultSet resultSet, boolean lowerCase, boolean useColumnLabel) throws SQLException {
        Objects.requireNonNull(resultSet, "resultSet");
        this.resultSet = resultSet;
        this.lowerCase = lowerCase;
        this.setUseColumnLabel(useColumnLabel);
        this.introspect(resultSet);
    }

    public Iterator<DynaBean> iterator() {
        return new ResultSetIterator(this);
    }

    public Object getObjectFromResultSet(String name) throws SQLException {
        return this.getObject(this.getResultSet(), name);
    }

    ResultSet getResultSet() {
        return this.resultSet;
    }

    @Override
    protected Class<?> loadClass(String className) throws SQLException {
        try {
            return this.getClass().getClassLoader().loadClass(className);
        }
        catch (Exception e) {
            throw new SQLException("Cannot load column class '" + className + "': " + e);
        }
    }
}

