/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2;

import java.io.Closeable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.pool2.DestroyMode;

public interface KeyedObjectPool<K, V, E extends Exception>
extends Closeable {
    public void addObject(K var1) throws E, IllegalStateException, UnsupportedOperationException;

    default public void addObjects(Collection<K> keys, int count) throws E, IllegalArgumentException {
        if (keys == null) {
            throw new IllegalArgumentException("keys must not be null.");
        }
        for (K key : keys) {
            this.addObjects(key, count);
        }
    }

    default public void addObjects(K key, int count) throws E, IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null.");
        }
        for (int i = 0; i < count; ++i) {
            this.addObject(key);
        }
    }

    public V borrowObject(K var1) throws E, NoSuchElementException, IllegalStateException;

    public void clear() throws E, UnsupportedOperationException;

    public void clear(K var1) throws E, UnsupportedOperationException;

    @Override
    public void close();

    default public List<K> getKeys() {
        return Collections.emptyList();
    }

    public int getNumActive();

    public int getNumActive(K var1);

    public int getNumIdle();

    public int getNumIdle(K var1);

    public void invalidateObject(K var1, V var2) throws E;

    default public void invalidateObject(K key, V obj, DestroyMode destroyMode) throws E {
        this.invalidateObject(key, obj);
    }

    public void returnObject(K var1, V var2) throws E;
}

