/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2;

import java.io.Closeable;
import java.util.NoSuchElementException;
import org.apache.commons.pool2.DestroyMode;

public interface ObjectPool<T, E extends Exception>
extends Closeable {
    public void addObject() throws E, IllegalStateException, UnsupportedOperationException;

    default public void addObjects(int count) throws E {
        for (int i = 0; i < count; ++i) {
            this.addObject();
        }
    }

    public T borrowObject() throws E, NoSuchElementException, IllegalStateException;

    public void clear() throws E, UnsupportedOperationException;

    @Override
    public void close();

    public int getNumActive();

    public int getNumIdle();

    public void invalidateObject(T var1) throws E;

    default public void invalidateObject(T obj, DestroyMode destroyMode) throws E {
        this.invalidateObject(obj);
    }

    public void returnObject(T var1) throws E;
}

