/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.impl;

import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.CacheStrategy;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileContentInfoFactory;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.FilesCache;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.cache.SoftRefFilesCache;
import org.apache.commons.vfs2.impl.DecoratedFileObject;
import org.apache.commons.vfs2.impl.DefaultVfsComponentContext;
import org.apache.commons.vfs2.impl.FileContentInfoFilenameFactory;
import org.apache.commons.vfs2.impl.FileTypeMap;
import org.apache.commons.vfs2.impl.URLStreamHandlerProxy;
import org.apache.commons.vfs2.impl.VirtualFileProvider;
import org.apache.commons.vfs2.impl.VirtualFileSystem;
import org.apache.commons.vfs2.operations.FileOperationProvider;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileProvider;
import org.apache.commons.vfs2.provider.DefaultURLStreamHandler;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.FileReplicator;
import org.apache.commons.vfs2.provider.LocalFileProvider;
import org.apache.commons.vfs2.provider.TemporaryFileStore;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.VfsComponent;

public class DefaultFileSystemManager
implements FileSystemManager {
    private final Map<String, FileProvider> providers = new HashMap<String, FileProvider>();
    private final List<String> virtualFileSystemSchemes = new ArrayList<String>();
    private final ArrayList<Object> components = new ArrayList();
    private final DefaultVfsComponentContext context = new DefaultVfsComponentContext(this);
    private final Map<String, List<FileOperationProvider>> operationProviders = new HashMap<String, List<FileOperationProvider>>();
    private final FileTypeMap typeMap = new FileTypeMap();
    private LocalFileProvider localFileProvider;
    private FileProvider defaultProvider;
    private FileReplicator fileReplicator;
    private FileObject baseFile;
    private FilesCache filesCache;
    private CacheStrategy fileCacheStrategy;
    private Class<?> fileObjectDecorator;
    private Constructor<?> fileObjectDecoratorConst;
    private FileContentInfoFactory fileContentInfoFactory;
    private Log log = LogFactory.getLog(this.getClass());
    private TemporaryFileStore tempFileStore;
    private VirtualFileProvider vfsProvider;
    private boolean init;

    protected Log getLogger() {
        return this.log;
    }

    public void addProvider(String urlScheme, FileProvider provider) throws FileSystemException {
        this.addProvider(new String[]{urlScheme}, provider);
    }

    public void addProvider(String[] urlSchemes, FileProvider provider) throws FileSystemException {
        for (String scheme2 : urlSchemes) {
            if (!this.providers.containsKey(scheme2)) continue;
            throw new FileSystemException("vfs.impl/multiple-providers-for-scheme.error", (Object)scheme2);
        }
        this.setupComponent(provider);
        Arrays.stream(urlSchemes).forEach(scheme -> this.providers.put((String)scheme, provider));
        if (provider instanceof LocalFileProvider && this.localFileProvider == null) {
            this.localFileProvider = (LocalFileProvider)provider;
        }
    }

    public void removeProvider(String urlScheme) {
        FileProvider provider = this.providers.remove(urlScheme);
        if (provider != null && !this.providers.containsValue(provider)) {
            this.closeComponent(provider);
        }
    }

    @Override
    public boolean hasProvider(String scheme) {
        return this.providers.containsKey(scheme);
    }

    public void addExtensionMap(String extension, String scheme) {
        this.typeMap.addExtension(extension, scheme);
    }

    public void addMimeTypeMap(String mimeType, String scheme) {
        this.typeMap.addMimeType(mimeType, scheme);
    }

    public void setDefaultProvider(FileProvider provider) throws FileSystemException {
        this.setupComponent(provider);
        this.defaultProvider = provider;
    }

    @Override
    public FilesCache getFilesCache() {
        return this.filesCache;
    }

    public void setFilesCache(FilesCache filesCache) throws FileSystemException {
        if (this.init) {
            throw new FileSystemException("vfs.impl/already-inited.error");
        }
        this.filesCache = filesCache;
    }

    public void setCacheStrategy(CacheStrategy fileCacheStrategy) throws FileSystemException {
        if (this.init) {
            throw new FileSystemException("vfs.impl/already-inited.error");
        }
        this.fileCacheStrategy = fileCacheStrategy;
    }

    @Override
    public CacheStrategy getCacheStrategy() {
        return this.fileCacheStrategy;
    }

    @Override
    public Class<?> getFileObjectDecorator() {
        return this.fileObjectDecorator;
    }

    @Override
    public Constructor<?> getFileObjectDecoratorConst() {
        return this.fileObjectDecoratorConst;
    }

    public void setFileObjectDecorator(Class<?> fileObjectDecorator) throws FileSystemException {
        if (this.init) {
            throw new FileSystemException("vfs.impl/already-inited.error");
        }
        if (!DecoratedFileObject.class.isAssignableFrom(fileObjectDecorator)) {
            throw new FileSystemException("vfs.impl/invalid-decorator.error", (Object)fileObjectDecorator.getName());
        }
        try {
            this.fileObjectDecoratorConst = fileObjectDecorator.getConstructor(FileObject.class);
        }
        catch (NoSuchMethodException e) {
            throw new FileSystemException("vfs.impl/invalid-decorator.error", (Object)fileObjectDecorator.getName(), (Throwable)e);
        }
        this.fileObjectDecorator = fileObjectDecorator;
    }

    @Override
    public FileContentInfoFactory getFileContentInfoFactory() {
        return this.fileContentInfoFactory;
    }

    public void setFileContentInfoFactory(FileContentInfoFactory fileContentInfoFactory) throws FileSystemException {
        if (this.init) {
            throw new FileSystemException("vfs.impl/already-inited.error");
        }
        this.fileContentInfoFactory = fileContentInfoFactory;
    }

    public void setReplicator(FileReplicator replicator) throws FileSystemException {
        this.setupComponent(replicator);
        this.fileReplicator = replicator;
    }

    public void setTemporaryFileStore(TemporaryFileStore tempFileStore) throws FileSystemException {
        this.setupComponent(tempFileStore);
        this.tempFileStore = tempFileStore;
    }

    @Override
    public void setLogger(Log log) {
        this.log = log;
    }

    private void setupComponent(Object component) throws FileSystemException {
        if (!this.components.contains(component)) {
            if (component instanceof VfsComponent) {
                VfsComponent vfsComponent = (VfsComponent)component;
                vfsComponent.setLogger(this.getLogger());
                vfsComponent.setContext(this.context);
                vfsComponent.init();
            }
            this.components.add(component);
        }
    }

    private void closeComponent(Object component) {
        if (component != null && this.components.contains(component)) {
            if (component instanceof VfsComponent) {
                ((VfsComponent)component).close();
            }
            this.components.remove(component);
        }
    }

    public FileReplicator getReplicator() throws FileSystemException {
        return FileSystemException.requireNonNull(this.fileReplicator, "vfs.impl/no-replicator.error");
    }

    public TemporaryFileStore getTemporaryFileStore() throws FileSystemException {
        return FileSystemException.requireNonNull(this.tempFileStore, "vfs.impl/no-temp-file-store.error");
    }

    public void init() throws FileSystemException {
        if (this.fileContentInfoFactory == null) {
            this.fileContentInfoFactory = new FileContentInfoFilenameFactory();
        }
        if (this.filesCache == null) {
            this.filesCache = new SoftRefFilesCache();
        }
        if (this.fileCacheStrategy == null) {
            this.fileCacheStrategy = CacheStrategy.ON_RESOLVE;
        }
        this.setupComponent(this.filesCache);
        this.vfsProvider = new VirtualFileProvider();
        this.setupComponent(this.vfsProvider);
        this.init = true;
    }

    @Override
    public void close() {
        if (!this.init) {
            return;
        }
        this.providers.values().forEach(this::closeComponent);
        this.closeComponent(this.vfsProvider);
        this.closeComponent(this.fileReplicator);
        this.closeComponent(this.tempFileStore);
        this.closeComponent(this.defaultProvider);
        this.providers.clear();
        this.operationProviders.values().forEach(opProviders -> opProviders.forEach(this::closeComponent));
        this.operationProviders.clear();
        this.typeMap.clear();
        if (!this.components.isEmpty()) {
            this.log.warn((Object)("DefaultFilesystemManager.close: not all components are closed: " + this.components.toString()));
        }
        this.components.clear();
        this.vfsProvider = null;
        this.virtualFileSystemSchemes.clear();
        if (this.filesCache != null) {
            this.filesCache.close();
        }
        this.defaultProvider = null;
        this.baseFile = null;
        this.fileObjectDecorator = null;
        this.fileObjectDecoratorConst = null;
        this.localFileProvider = null;
        this.fileReplicator = null;
        this.tempFileStore = null;
        this.filesCache = null;
        this.fileCacheStrategy = null;
        this.fileContentInfoFactory = null;
        this.init = false;
    }

    public void freeUnusedResources() {
        if (!this.init) {
            return;
        }
        for (FileProvider fileProvider : this.providers.values()) {
            if (!(fileProvider instanceof AbstractFileProvider)) continue;
            ((AbstractFileProvider)fileProvider).freeUnusedResources();
        }
    }

    public void setBaseFile(FileObject baseFile) throws FileSystemException {
        this.baseFile = baseFile;
    }

    public void setBaseFile(File baseFile) throws FileSystemException {
        this.baseFile = this.getLocalFileProvider().findLocalFile(baseFile);
    }

    @Override
    public FileObject getBaseFile() throws FileSystemException {
        return this.baseFile;
    }

    @Override
    public FileObject resolveFile(String uri) throws FileSystemException {
        return this.resolveFile(this.getBaseFile(), uri);
    }

    @Override
    public FileObject resolveFile(String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        return this.resolveFile(this.getBaseFile(), uri, fileSystemOptions);
    }

    @Override
    public FileObject resolveFile(File baseFile, String uri) throws FileSystemException {
        return this.resolveFile(this.getLocalFileProvider().findLocalFile(baseFile), uri);
    }

    @Override
    public FileObject resolveFile(FileObject baseFile, String uri) throws FileSystemException {
        return this.resolveFile(baseFile, uri, baseFile == null ? null : baseFile.getFileSystem().getFileSystemOptions());
    }

    public FileObject resolveFile(FileObject baseFile, String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileProvider provider;
        FileObject realBaseFile = baseFile != null && VFS.isUriStyle() && baseFile.getName().isFile() ? baseFile.getParent() : baseFile;
        UriParser.checkUriEncoding(uri);
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        String scheme = UriParser.extractScheme(this.getSchemes(), uri);
        if (scheme != null && (provider = this.providers.get(scheme)) != null) {
            return provider.findFile(realBaseFile, uri, fileSystemOptions);
        }
        if (this.localFileProvider != null && this.localFileProvider.isAbsoluteLocalName(uri)) {
            return this.localFileProvider.findLocalFile(uri);
        }
        if (scheme != null) {
            FileSystemException.requireNonNull(this.defaultProvider, "vfs.impl/unknown-scheme.error", scheme, uri);
            return this.defaultProvider.findFile(realBaseFile, uri, fileSystemOptions);
        }
        FileSystemException.requireNonNull(realBaseFile, "vfs.impl/find-rel-file.error", uri);
        return realBaseFile.resolveFile(uri);
    }

    @Override
    public FileName resolveName(FileName root, String path) throws FileSystemException {
        return this.resolveName(root, path, NameScope.FILE_SYSTEM);
    }

    @Override
    public FileName resolveName(FileName base, String name, NameScope scope) throws FileSystemException {
        String fullPath;
        FileSystemException.requireNonNull(base, "Invalid base FileName.");
        FileSystemException.requireNonNull(name, "Invalid name FileName.");
        FileName realBase = VFS.isUriStyle() && base.isFile() ? base.getParent() : base;
        StringBuilder buffer = new StringBuilder(name);
        UriParser.fixSeparators(buffer);
        String scheme = UriParser.extractScheme(this.getSchemes(), buffer.toString());
        if (name.isEmpty() || scheme == null && buffer.charAt(0) != '/') {
            if (!VFS.isUriStyle()) {
                buffer.insert(0, '/');
            }
            buffer.insert(0, realBase.getPath());
        }
        FileType fileType = UriParser.normalisePath(buffer);
        String resolvedPath = buffer.toString();
        if (!AbstractFileName.checkName(realBase.getPath(), resolvedPath, scope)) {
            throw new FileSystemException("vfs.provider/invalid-descendent-name.error", (Object)name);
        }
        if (scheme != null) {
            fullPath = resolvedPath;
        } else {
            scheme = realBase.getScheme();
            fullPath = realBase.getRootURI() + resolvedPath;
        }
        FileProvider provider = this.providers.get(scheme);
        if (provider != null) {
            return provider.parseUri(realBase, fullPath);
        }
        if (scheme != null && this.defaultProvider != null) {
            return this.defaultProvider.parseUri(realBase, fullPath);
        }
        return ((AbstractFileName)realBase).createName(resolvedPath, fileType);
    }

    @Override
    public FileName resolveURI(String uri) throws FileSystemException {
        FileProvider provider;
        UriParser.checkUriEncoding(uri);
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        String scheme = UriParser.extractScheme(this.getSchemes(), uri);
        if (scheme != null && (provider = this.providers.get(scheme)) != null) {
            return provider.parseUri(null, uri);
        }
        if (this.localFileProvider != null && this.localFileProvider.isAbsoluteLocalName(uri)) {
            return this.localFileProvider.parseUri(null, uri);
        }
        if (scheme != null) {
            FileSystemException.requireNonNull(this.defaultProvider, "vfs.impl/unknown-scheme.error", scheme, uri);
            return this.defaultProvider.parseUri(null, uri);
        }
        FileSystemException.requireNonNull(this.baseFile, "vfs.impl/find-rel-file.error", uri);
        return this.resolveName(this.baseFile.getName(), uri, NameScope.FILE_SYSTEM);
    }

    @Override
    public FileObject toFileObject(File file) throws FileSystemException {
        return this.getLocalFileProvider().findLocalFile(file);
    }

    @Override
    public FileObject createFileSystem(String scheme, FileObject file) throws FileSystemException {
        FileProvider provider = this.providers.get(scheme);
        FileSystemException.requireNonNull(provider, "vfs.impl/unknown-provider.error", scheme, file);
        return provider.createFileSystem(scheme, file, file.getFileSystem().getFileSystemOptions());
    }

    @Override
    public FileObject createFileSystem(FileObject file) throws FileSystemException {
        String scheme = this.typeMap.getScheme(file);
        FileSystemException.requireNonNull(scheme, "vfs.impl/no-provider-for-file.error", file);
        return this.createFileSystem(scheme, file);
    }

    @Override
    public boolean canCreateFileSystem(FileObject file) throws FileSystemException {
        return this.typeMap.getScheme(file) != null;
    }

    @Override
    public FileObject createVirtualFileSystem(FileObject rootFile) throws FileSystemException {
        FileObject fileObject = this.vfsProvider.createFileSystem(rootFile);
        this.addVirtualFileSystemScheme(rootFile.getName().getScheme());
        return fileObject;
    }

    @Override
    public FileObject createVirtualFileSystem(String rootUri) throws FileSystemException {
        FileObject fileObject = this.vfsProvider.createFileSystem(rootUri);
        this.addVirtualFileSystemScheme(rootUri);
        return fileObject;
    }

    protected void addVirtualFileSystemScheme(String rootUri) {
        if (rootUri.indexOf(58) != -1) {
            rootUri = rootUri.substring(0, rootUri.indexOf(58));
        }
        this.virtualFileSystemSchemes.add(rootUri);
    }

    private LocalFileProvider getLocalFileProvider() throws FileSystemException {
        return FileSystemException.requireNonNull(this.localFileProvider, "vfs.impl/no-local-file-provider.error");
    }

    @Override
    public URLStreamHandlerFactory getURLStreamHandlerFactory() {
        return new VfsStreamHandlerFactory();
    }

    @Override
    public void closeFileSystem(FileSystem fileSystem) {
        this.getFilesCache().clear(fileSystem);
        this._closeFileSystem(fileSystem);
    }

    public void _closeFileSystem(FileSystem fileSystem) {
        FileProvider provider = this.providers.get(fileSystem.getRootName().getScheme());
        if (provider != null) {
            ((AbstractFileProvider)provider).closeFileSystem(fileSystem);
        } else if (fileSystem instanceof VirtualFileSystem) {
            this.vfsProvider.closeFileSystem(fileSystem);
        }
    }

    @Override
    public String[] getSchemes() {
        ArrayList<String> schemes = new ArrayList<String>(this.providers.size() + this.virtualFileSystemSchemes.size());
        schemes.addAll(this.providers.keySet());
        schemes.addAll(this.virtualFileSystemSchemes);
        return schemes.toArray(new String[0]);
    }

    @Override
    public Collection<Capability> getProviderCapabilities(String scheme) throws FileSystemException {
        FileProvider provider = this.providers.get(scheme);
        FileSystemException.requireNonNull(provider, "vfs.impl/unknown-scheme.error", scheme);
        return provider.getCapabilities();
    }

    @Override
    public FileSystemConfigBuilder getFileSystemConfigBuilder(String scheme) throws FileSystemException {
        FileProvider provider = this.providers.get(scheme);
        FileSystemException.requireNonNull(provider, "vfs.impl/unknown-scheme.error", scheme);
        return provider.getConfigBuilder();
    }

    @Override
    public void addOperationProvider(String scheme, FileOperationProvider operationProvider) throws FileSystemException {
        this.addOperationProvider(new String[]{scheme}, operationProvider);
    }

    @Override
    public void addOperationProvider(String[] schemes, FileOperationProvider operationProvider) throws FileSystemException {
        for (String scheme : schemes) {
            List<Object> providers;
            if (!this.operationProviders.containsKey(scheme)) {
                providers = new ArrayList();
                this.operationProviders.put(scheme, providers);
            }
            if ((providers = this.operationProviders.get(scheme)).contains(operationProvider)) {
                throw new FileSystemException("vfs.operation/operation-provider-already-added.error", (Object)scheme);
            }
            this.setupComponent(operationProvider);
            providers.add(operationProvider);
        }
    }

    @Override
    public FileOperationProvider[] getOperationProviders(String scheme) throws FileSystemException {
        List<FileOperationProvider> providers = this.operationProviders.get(scheme);
        if (providers == null || providers.isEmpty()) {
            return null;
        }
        return providers.toArray(new FileOperationProvider[0]);
    }

    @Override
    public FileObject resolveFile(URI uri) throws FileSystemException {
        return this.resolveFile(this.baseFile, uri.toString(), null);
    }

    @Override
    public FileObject resolveFile(URL url) throws FileSystemException {
        try {
            return this.resolveFile(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new FileSystemException(e);
        }
    }

    final class VfsStreamHandlerFactory
    implements URLStreamHandlerFactory {
        VfsStreamHandlerFactory() {
        }

        @Override
        public URLStreamHandler createURLStreamHandler(String protocol) {
            FileProvider provider = (FileProvider)DefaultFileSystemManager.this.providers.get(protocol);
            if (provider != null) {
                return new DefaultURLStreamHandler(DefaultFileSystemManager.this.context);
            }
            return new URLStreamHandlerProxy();
        }
    }
}

