/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.AbstractVfsContainer;
import org.apache.commons.vfs2.provider.FileNameParser;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.FileSystemKey;
import org.apache.commons.vfs2.provider.local.GenericFileNameParser;

public abstract class AbstractFileProvider
extends AbstractVfsContainer
implements FileProvider {
    private static final AbstractFileSystem[] EMPTY_ABSTRACT_FILE_SYSTEMS = new AbstractFileSystem[0];
    private final Map<FileSystemKey, FileSystem> fileSystemMap = new TreeMap<FileSystemKey, FileSystem>();
    private FileNameParser parser = GenericFileNameParser.getInstance();

    protected FileNameParser getFileNameParser() {
        return this.parser;
    }

    protected void setFileNameParser(FileNameParser parser) {
        this.parser = parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Map<FileSystemKey, FileSystem> map = this.fileSystemMap;
        synchronized (map) {
            this.fileSystemMap.clear();
        }
        super.close();
    }

    @Override
    public FileObject createFileSystem(String scheme, FileObject file, FileSystemOptions fileSystemOptions) throws FileSystemException {
        throw new FileSystemException("vfs.provider/not-layered-fs.error", (Object)scheme);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFileSystem(Comparable<?> key, FileSystem fs) throws FileSystemException {
        this.addComponent(fs);
        FileSystemKey treeKey = new FileSystemKey(key, fs.getFileSystemOptions());
        ((AbstractFileSystem)fs).setCacheKey(treeKey);
        Map<FileSystemKey, FileSystem> map = this.fileSystemMap;
        synchronized (map) {
            this.fileSystemMap.put(treeKey, fs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileSystem findFileSystem(Comparable<?> key, FileSystemOptions fileSystemOptions) {
        Map<FileSystemKey, FileSystem> map = this.fileSystemMap;
        synchronized (map) {
            return this.fileSystemMap.get(new FileSystemKey(key, fileSystemOptions));
        }
    }

    @Override
    public FileSystemConfigBuilder getConfigBuilder() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeUnusedResources() {
        AbstractFileSystem[] abstractFileSystems;
        Map<FileSystemKey, FileSystem> map = this.fileSystemMap;
        synchronized (map) {
            abstractFileSystems = this.fileSystemMap.values().toArray(EMPTY_ABSTRACT_FILE_SYSTEMS);
        }
        Arrays.stream(abstractFileSystems).filter(AbstractFileSystem::isReleaseable).forEach(AbstractFileSystem::closeCommunicationLink);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeFileSystem(FileSystem fileSystem) {
        AbstractFileSystem fs = (AbstractFileSystem)fileSystem;
        FileSystemKey key = fs.getCacheKey();
        if (key != null) {
            Map<FileSystemKey, FileSystem> map = this.fileSystemMap;
            synchronized (map) {
                this.fileSystemMap.remove(key);
            }
        }
        this.removeComponent(fs);
        fs.close();
    }

    @Override
    public FileName parseUri(FileName base, String uri) throws FileSystemException {
        if (this.getFileNameParser() != null) {
            return this.getFileNameParser().parseUri(this.getContext(), base, uri);
        }
        throw new FileSystemException("vfs.provider/filename-parser-missing.error");
    }
}

