/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.interceptor;

import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.JAXRSServiceImpl;
import org.apache.cxf.jaxrs.ext.RequestHandler;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.RequestPreprocessor;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXRSInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSInInterceptor.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAXRSInInterceptor.class);
    private static final String RESOURCE_METHOD = "org.apache.cxf.resource.method";
    private static final String RESOURCE_OPERATION_NAME = "org.apache.cxf.resource.operation.name";

    public JAXRSInInterceptor() {
        super("unmarshal");
    }

    public void handleFault(Message message) {
        super.handleFault(message);
        LOG.fine("Cleanup thread local variables");
        Object rootInstance = message.getExchange().remove((Object)"service.root.instance");
        Object rootProvider = message.getExchange().remove((Object)"service.root.provider");
        if (rootInstance != null && rootProvider != null) {
            try {
                ((ResourceProvider)rootProvider).releaseInstance(message, rootInstance);
            }
            catch (Throwable tex) {
                LOG.warning("Exception occurred during releasing the service instance, " + tex.getMessage());
            }
        }
        ProviderFactory.getInstance(message).clearThreadLocalProxies();
        ClassResourceInfo cri = (ClassResourceInfo)message.getExchange().get((Object)"root.resource.class");
        if (cri != null) {
            cri.clearThreadLocalProxies();
        }
    }

    public void handleMessage(Message message) {
        try {
            this.processRequest(message);
        }
        catch (RuntimeException ex) {
            Response excResponse = JAXRSUtils.convertFaultToResponse(ex, message);
            if (excResponse == null) {
                ProviderFactory.getInstance(message).clearThreadLocalProxies();
                message.getExchange().put((Object)Message.PROPOGATE_EXCEPTION, (Object)JAXRSUtils.propogateException(message));
                throw ex;
            }
            message.getExchange().put(Response.class, (Object)excResponse);
        }
    }

    private void processRequest(Message message) {
        if (message.getExchange().get(OperationResourceInfo.class) != null) {
            return;
        }
        RequestPreprocessor rp = ProviderFactory.getInstance(message).getRequestPreprocessor();
        if (rp != null) {
            rp.preprocess(message, new UriInfoImpl(message, null));
            if (message.getExchange().get(Response.class) != null) {
                return;
            }
        }
        String httpMethod = HttpUtils.getProtocolHeader(message, "org.apache.cxf.request.method", "POST", true);
        String requestContentType = (String)message.get((Object)"Content-Type");
        if (requestContentType == null) {
            requestContentType = "*/*";
        }
        String rawPath = HttpUtils.getPathToMatch(message, true);
        Service service = (Service)message.getExchange().get(Service.class);
        List<ClassResourceInfo> resources = ((JAXRSServiceImpl)service).getClassResourceInfos();
        String acceptTypes = HttpUtils.getProtocolHeader(message, "Accept", null);
        if (acceptTypes == null) {
            acceptTypes = "*/*";
            message.put((Object)"Accept", (Object)acceptTypes);
        }
        List<MediaType> acceptContentTypes = null;
        try {
            acceptContentTypes = JAXRSUtils.sortMediaTypes(acceptTypes);
        }
        catch (IllegalArgumentException ex) {
            throw new WebApplicationException(406);
        }
        message.getExchange().put((Object)"Accept", acceptContentTypes);
        MetadataMap<String, String> values = new MetadataMap<String, String>();
        ClassResourceInfo resource = JAXRSUtils.selectResourceClass(resources, rawPath, values, message);
        if (resource == null) {
            org.apache.cxf.common.i18n.Message errorMsg = new org.apache.cxf.common.i18n.Message("NO_ROOT_EXC", BUNDLE, new Object[]{message.get((Object)"org.apache.cxf.request.uri"), rawPath});
            LOG.warning(errorMsg.toString());
            Response resp = JAXRSUtils.createResponse(resource, message, errorMsg.toString(), Response.Status.NOT_FOUND.getStatusCode(), false);
            throw new WebApplicationException(resp);
        }
        message.getExchange().put((Object)"root.resource.class", (Object)resource);
        OperationResourceInfo ori = null;
        boolean operChecked = false;
        List<ProviderInfo<RequestHandler>> shs = ProviderFactory.getInstance(message).getRequestHandlers();
        for (ProviderInfo<RequestHandler> sh : shs) {
            String newAcceptTypes = HttpUtils.getProtocolHeader(message, "Accept", "*/*");
            if (!acceptTypes.equals(newAcceptTypes) || ori == null && !operChecked) {
                acceptTypes = newAcceptTypes;
                acceptContentTypes = JAXRSUtils.sortMediaTypes(newAcceptTypes);
                message.getExchange().put((Object)"Accept", acceptContentTypes);
                if (ori != null) {
                    values = new MetadataMap();
                    resource = JAXRSUtils.selectResourceClass(resources, rawPath, values, message);
                }
                try {
                    ori = JAXRSUtils.findTargetMethod(resource, message, httpMethod, values, requestContentType, acceptContentTypes, false);
                    this.setExchangeProperties(message, ori, values, resources.size());
                }
                catch (WebApplicationException ex) {
                    operChecked = true;
                }
            }
            InjectionUtils.injectContextFields(sh.getProvider(), sh, message);
            InjectionUtils.injectContextMethods(sh.getProvider(), sh, message);
            Response response = sh.getProvider().handleRequest(message, resource);
            if (response == null) continue;
            message.getExchange().put(Response.class, (Object)response);
            return;
        }
        String newAcceptTypes = (String)message.get((Object)"Accept");
        if (!acceptTypes.equals(newAcceptTypes) || ori == null) {
            acceptTypes = newAcceptTypes;
            acceptContentTypes = JAXRSUtils.sortMediaTypes(acceptTypes);
            message.getExchange().put((Object)"Accept", acceptContentTypes);
            if (ori != null) {
                values = new MetadataMap();
                resource = JAXRSUtils.selectResourceClass(resources, rawPath, values, message);
            }
            try {
                ori = JAXRSUtils.findTargetMethod(resource, message, httpMethod, values, requestContentType, acceptContentTypes, true);
                this.setExchangeProperties(message, ori, values, resources.size());
            }
            catch (WebApplicationException ex) {
                if (JAXRSUtils.noResourceMethodForOptions(ex.getResponse(), httpMethod)) {
                    Response response = JAXRSUtils.createResponse(resource, null, null, 200, true);
                    message.getExchange().put(Response.class, (Object)response);
                    return;
                }
                throw ex;
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Request path is: " + rawPath);
            LOG.fine("Request HTTP method is: " + httpMethod);
            LOG.fine("Request contentType is: " + requestContentType);
            LOG.fine("Accept contentType is: " + acceptTypes);
            LOG.fine("Found operation: " + ori.getMethodToInvoke().getName());
        }
        this.setExchangeProperties(message, ori, values, resources.size());
        try {
            List<Object> params = JAXRSUtils.processParameters(ori, values, message);
            message.setContent(List.class, params);
        }
        catch (IOException ex) {
            Response excResponse = JAXRSUtils.convertFaultToResponse(ex, message);
            if (excResponse == null) {
                throw new WebApplicationException((Throwable)ex);
            }
            message.getExchange().put(Response.class, (Object)excResponse);
        }
    }

    private void setExchangeProperties(Message message, OperationResourceInfo ori, MultivaluedMap<String, String> values, int numberOfResources) {
        message.put((Object)"org.apache.cxf.rest.message", (Object)Boolean.TRUE);
        message.getExchange().put(OperationResourceInfo.class, (Object)ori);
        message.put((Object)RESOURCE_METHOD, (Object)ori.getMethodToInvoke());
        message.put((Object)"jaxrs.template.parameters", values);
        String plainOperationName = ori.getMethodToInvoke().getName();
        if (numberOfResources > 1) {
            plainOperationName = ori.getClassResourceInfo().getServiceClass().getSimpleName() + "#" + plainOperationName;
        }
        message.getExchange().put((Object)RESOURCE_OPERATION_NAME, (Object)plainOperationName);
        boolean oneway = ori.isOneway() || MessageUtils.isTrue((Object)HttpUtils.getProtocolHeader(message, "OnewayRequest", null));
        message.getExchange().setOneWay(oneway);
    }
}

