/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider.jsonp;

import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class JsonpInInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final String JSONP_TYPE = "application/x-javascript";
    public static final String CALLBACK_PARAM = "_jsonp";
    public static final String CALLBACK_KEY = "JSONP.CALLBACK";
    public static final String DEFAULT_CALLBACK_VALUE = "callback";
    private String callbackParam = "_jsonp";
    private String defaultCallback = "callback";
    private String acceptType;
    private String mediaType = "application/x-javascript";

    public JsonpInInterceptor() {
        this("unmarshal");
    }

    public JsonpInInterceptor(String phase) {
        super(phase);
    }

    public void handleMessage(Message message) throws Fault {
        String callbackValue = this.getCallbackValue(message);
        if (!StringUtils.isEmpty((String)callbackValue)) {
            if (this.getAcceptType() != null) {
                message.put((Object)"Accept", (Object)this.getAcceptType());
            }
            message.getExchange().put((Object)CALLBACK_KEY, (Object)callbackValue);
        }
    }

    protected String getCallbackValue(Message message) {
        String httpAcceptType;
        HttpServletRequest request = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
        String callback = request.getParameter(this.callbackParam);
        if (StringUtils.isEmpty((String)callback) && (httpAcceptType = (String)message.get((Object)"Accept")) != null && this.mediaType.equals(httpAcceptType)) {
            return this.defaultCallback;
        }
        return callback;
    }

    public void setCallbackParam(String callbackParam) {
        this.callbackParam = callbackParam;
    }

    public String getCallbackParam() {
        return this.callbackParam;
    }

    public void setAcceptType(String acceptType) {
        this.acceptType = acceptType;
    }

    public String getAcceptType() {
        return this.acceptType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setDefaultCallback(String defaultCallback) {
        this.defaultCallback = defaultCallback;
    }

    public String getDefaultCallback() {
        return this.defaultCallback;
    }
}

