/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.auth;

import java.net.URI;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.interceptor.security.NamePasswordCallbackHandler;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public abstract class AbstractSpnegoAuthSupplier {
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractSpnegoAuthSupplier.class);
    private static final String PROPERTY_USE_KERBEROS_OID = "auth.spnego.useKerberosOid";
    private static final String PROPERTY_REQUIRE_CRED_DELEGATION = "auth.spnego.requireCredDelegation";
    private static final String KERBEROS_OID = "1.2.840.113554.1.2.2";
    private static final String SPNEGO_OID = "1.3.6.1.5.5.2";
    private String servicePrincipalName;
    private String realm;
    private boolean credDelegation;
    private Configuration loginConfig;
    private Oid serviceNameType;

    public String getAuthorization(AuthorizationPolicy authPolicy, URI currentURI, Message message) {
        if (!"Negotiate".equals(authPolicy.getAuthorizationType())) {
            return null;
        }
        try {
            String spn = this.getCompleteServicePrincipalName(currentURI);
            boolean useKerberosOid = MessageUtils.isTrue((Object)message.getContextualProperty(PROPERTY_USE_KERBEROS_OID));
            Oid oid = new Oid(useKerberosOid ? KERBEROS_OID : SPNEGO_OID);
            byte[] token = this.getToken(authPolicy, spn, oid, message);
            return "Negotiate " + Base64Utility.encode((byte[])token);
        }
        catch (LoginException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (GSSException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private byte[] getToken(AuthorizationPolicy authPolicy, GSSContext context) throws GSSException, LoginException {
        byte[] token = new byte[]{};
        if (authPolicy == null) {
            return context.initSecContext(token, 0, token.length);
        }
        String contextName = authPolicy.getAuthorization();
        if (contextName == null) {
            contextName = "";
        }
        if (StringUtils.isEmpty((String)authPolicy.getUserName()) && StringUtils.isEmpty((String)contextName) && this.loginConfig == null) {
            return context.initSecContext(token, 0, token.length);
        }
        CallbackHandler callbackHandler = this.getUsernamePasswordHandler(authPolicy.getUserName(), authPolicy.getPassword());
        LoginContext lc = new LoginContext(contextName, null, callbackHandler, this.loginConfig);
        lc.login();
        try {
            return Subject.doAs(lc.getSubject(), new CreateServiceTicketAction(context, token));
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof GSSException) {
                throw (GSSException)e.getCause();
            }
            LOG.log(Level.SEVERE, "initSecContext", e);
            return null;
        }
    }

    private byte[] getToken(AuthorizationPolicy authPolicy, String spn, Oid oid, Message message) throws GSSException, LoginException {
        GSSManager manager = GSSManager.getInstance();
        GSSName serverName = manager.createName(spn, this.serviceNameType);
        GSSCredential delegatedCred = (GSSCredential)message.getContextualProperty(GSSCredential.class.getName());
        GSSContext context = manager.createContext(serverName.canonicalize(oid), oid, delegatedCred, 0);
        context.requestCredDeleg(this.isCredDelegationRequired(message));
        return this.getToken((AuthorizationPolicy)(delegatedCred == null ? authPolicy : null), context);
    }

    protected boolean isCredDelegationRequired(Message message) {
        Object prop = message.getContextualProperty(PROPERTY_REQUIRE_CRED_DELEGATION);
        return prop == null ? this.credDelegation : MessageUtils.isTrue((Object)prop);
    }

    protected String getCompleteServicePrincipalName(URI currentURI) {
        String name;
        String string = name = this.servicePrincipalName == null ? "HTTP/" + currentURI.getHost() : this.servicePrincipalName;
        if (this.realm != null) {
            name = name + "@" + this.realm;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Service Principal Name is " + name);
        }
        return name;
    }

    public void setServicePrincipalName(String servicePrincipalName) {
        this.servicePrincipalName = servicePrincipalName;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public CallbackHandler getUsernamePasswordHandler(String username, String password) {
        if (StringUtils.isEmpty((String)username)) {
            return null;
        }
        return new NamePasswordCallbackHandler(username, password);
    }

    public void setCredDelegation(boolean delegation) {
        this.credDelegation = delegation;
    }

    public void setLoginConfig(Configuration config) {
        this.loginConfig = config;
    }

    public Oid getServiceNameType() {
        return this.serviceNameType;
    }

    public void setServiceNameType(Oid serviceNameType) {
        this.serviceNameType = serviceNameType;
    }

    private final class CreateServiceTicketAction
    implements PrivilegedExceptionAction<byte[]> {
        private final GSSContext context;
        private final byte[] token;

        private CreateServiceTicketAction(GSSContext context, byte[] token) {
            this.context = context;
            this.token = token;
        }

        @Override
        public byte[] run() throws GSSException {
            return this.context.initSecContext(this.token, 0, this.token.length);
        }
    }
}

