/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jpa.impl.transaction.context;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.spi.Contextual;
import org.apache.deltaspike.jpa.impl.transaction.context.EntityManagerEntry;
import org.apache.deltaspike.jpa.impl.transaction.context.TransactionBeanEntry;

public class TransactionBeanStorage {
    private static final Logger LOGGER = Logger.getLogger(TransactionBeanStorage.class.getName());
    private static ThreadLocal<TransactionBeanStorage> transactionBeanStorage = new ThreadLocal();
    private Stack<TransactionContextInfo> oldTci = new Stack();
    private TransactionContextInfo currentTci = null;

    private TransactionBeanStorage() {
    }

    public static TransactionBeanStorage getInstance() {
        TransactionBeanStorage result = transactionBeanStorage.get();
        if (result == null) {
            result = new TransactionBeanStorage();
            transactionBeanStorage.set(result);
        }
        return result;
    }

    public static void close() {
        TransactionBeanStorage currentStorage = transactionBeanStorage.get();
        if (currentStorage != null) {
            currentStorage.endAllTransactionScopes();
            transactionBeanStorage.set(null);
            transactionBeanStorage.remove();
        }
    }

    public static boolean isOpen() {
        return transactionBeanStorage.get() != null;
    }

    public int incrementRefCounter() {
        return this.currentTci.refCounter.incrementAndGet() - 1;
    }

    public int decrementRefCounter() {
        if (this.currentTci == null) {
            return 0;
        }
        return this.currentTci.refCounter.decrementAndGet();
    }

    public boolean isEmpty() {
        return this.currentTci == null;
    }

    public void startTransactionScope() {
        if (this.currentTci != null) {
            this.oldTci.push(this.currentTci);
        }
        this.currentTci = new TransactionContextInfo();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("starting TransactionScope");
        }
    }

    public void endTransactionScope() {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("ending TransactionScope");
        }
        this.destroyBeans(this.currentTci.contextualInstances);
        if (this.oldTci.size() > 0) {
            this.currentTci = this.oldTci.pop();
            this.endTransactionScope();
        } else {
            this.currentTci = null;
        }
    }

    public void storeUsedEntityManager(EntityManagerEntry entityManagerEntry) {
        this.currentTci.ems.add(entityManagerEntry);
    }

    public Set<EntityManagerEntry> getUsedEntityManagerEntries() {
        return this.currentTci.ems;
    }

    public void cleanUsedEntityManagers() {
        this.currentTci.ems.clear();
    }

    public Map<Contextual, TransactionBeanEntry> getActiveTransactionContext() {
        if (this.currentTci == null) {
            return null;
        }
        return this.currentTci.contextualInstances;
    }

    private void endAllTransactionScopes() {
        while (!this.isEmpty()) {
            this.endTransactionScope();
        }
    }

    private void destroyBeans(Map<Contextual, TransactionBeanEntry> activeBeans) {
        for (TransactionBeanEntry beanEntry : activeBeans.values()) {
            beanEntry.getBean().destroy(beanEntry.getContextualInstance(), beanEntry.getCreationalContext());
        }
    }

    private static class TransactionContextInfo {
        private Map<Contextual, TransactionBeanEntry> contextualInstances = new HashMap<Contextual, TransactionBeanEntry>();
        private Set<EntityManagerEntry> ems = new HashSet<EntityManagerEntry>();
        private AtomicInteger refCounter = new AtomicInteger(0);

        private TransactionContextInfo() {
        }
    }
}

