/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.proxy.impl.invocation;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;
import javax.inject.Inject;
import org.apache.deltaspike.proxy.impl.invocation.InterceptorLookup;
import org.apache.deltaspike.proxy.impl.invocation.ManualInvocationContext;
import org.apache.deltaspike.proxy.impl.invocation.ManualInvocationThrowableWrapperException;

public abstract class AbstractManualInvocationHandler
implements InvocationHandler {
    @Inject
    private InterceptorLookup interceptorLookup;

    @Override
    public Object invoke(Object proxy, Method method, Object[] parameters) throws Throwable {
        List interceptors = this.interceptorLookup.lookup(proxy, method);
        if (interceptors != null && !interceptors.isEmpty()) {
            try {
                ManualInvocationContext invocationContext = new ManualInvocationContext(this, interceptors, proxy, method, parameters, null);
                Object returnValue = invocationContext.proceed();
                if (invocationContext.isProceedOriginal()) {
                    return invocationContext.getProceedOriginalReturnValue();
                }
                return returnValue;
            }
            catch (ManualInvocationThrowableWrapperException e) {
                throw e.getCause();
            }
        }
        return this.proceedOriginal(proxy, method, parameters);
    }

    protected abstract Object proceedOriginal(Object var1, Method var2, Object[] var3) throws Throwable;
}

