/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.xml;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class IOUtils {
    private static final SAXTransformerFactory FACTORY = (SAXTransformerFactory)TransformerFactory.newInstance();
    private static final String XML_NAMESPACE_URI = "http://www.w3.org/XML/1998/namespace";

    public static final void parse(File file, ContentHandler handler) throws IOException, TransformerException {
        Transformer transformer = FACTORY.newTransformer();
        transformer.transform(new StreamSource(new FileReader(file)), new SAXResult(handler));
    }

    public static ContentHandler getSerializer(File file) throws IOException, TransformerException {
        FileWriter writer = new FileWriter(file);
        TransformerHandler transformerHandler = FACTORY.newTransformerHandler();
        Transformer transformer = transformerHandler.getTransformer();
        Properties format = new Properties();
        format.put("method", "xml");
        format.put("omit-xml-declaration", "no");
        format.put("encoding", "UTF-8");
        format.put("indent", "yes");
        transformer.setOutputProperties(format);
        transformerHandler.setResult(new StreamResult(writer));
        try {
            if (IOUtils.needsNamespacesAsAttributes(format)) {
                return new NamespaceAsAttributes(transformerHandler);
            }
        }
        catch (SAXException se) {
            throw new TransformerException("Unable to detect of namespace support for sax works properly.", se);
        }
        return transformerHandler;
    }

    protected static boolean needsNamespacesAsAttributes(Properties format) throws TransformerException, SAXException {
        StringWriter writer = new StringWriter();
        String uri = "namespaceuri";
        String prefix = "nsp";
        String check = "xmlns:nsp='namespaceuri'";
        TransformerHandler handler = FACTORY.newTransformerHandler();
        handler.getTransformer().setOutputProperties(format);
        handler.setResult(new StreamResult(writer));
        handler.startDocument();
        handler.startPrefixMapping("nsp", "namespaceuri");
        handler.startElement("namespaceuri", "element", "element", new AttributesImpl());
        handler.endElement("namespaceuri", "element", "element");
        handler.endPrefixMapping("nsp");
        handler.endDocument();
        String text = writer.toString();
        boolean needsIt = text.replace('\"', '\'').indexOf("xmlns:nsp='namespaceuri'") == -1;
        return needsIt;
    }

    protected static void addAttribute(AttributesImpl ai, String name, Object value) {
        if (value != null) {
            ai.addAttribute("", name, name, "CDATA", value.toString());
        }
    }

    protected static void text(ContentHandler ch, String text) throws SAXException {
        if (text != null) {
            char[] c = text.toCharArray();
            ch.characters(c, 0, c.length);
        }
    }

    protected static void indent(ContentHandler ch, int level) throws SAXException {
        for (int i = 0; i < level; ++i) {
            IOUtils.text(ch, "    ");
        }
    }

    protected static void newline(ContentHandler ch) throws SAXException {
        IOUtils.text(ch, "\n");
    }

    public static class NamespaceAsAttributes
    implements ContentHandler {
        private final ContentHandler contentHandler;
        private List prefixList = new ArrayList();
        private List uriList = new ArrayList();
        private Map uriToPrefixMap = new HashMap();
        private Map prefixToUriMap = new HashMap();
        private boolean hasMappings = false;

        public NamespaceAsAttributes(ContentHandler ch) {
            this.contentHandler = ch;
        }

        public void startDocument() throws SAXException {
            this.uriToPrefixMap.clear();
            this.prefixToUriMap.clear();
            this.clearMappings();
            this.contentHandler.startDocument();
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (uri != null && !prefix.startsWith("xml")) {
                this.hasMappings = true;
                this.prefixList.add(prefix);
                this.uriList.add(uri);
                if (prefix.length() > 0) {
                    this.uriToPrefixMap.put(uri, prefix + ":");
                } else {
                    this.uriToPrefixMap.put(uri, prefix);
                }
                this.prefixToUriMap.put(prefix, uri);
            }
            this.contentHandler.startPrefixMapping(prefix, uri);
        }

        public void startElement(String eltUri, String eltLocalName, String eltQName, Attributes attrs) throws SAXException {
            if (null != eltUri && eltUri.length() != 0 && this.uriToPrefixMap.containsKey(eltUri)) {
                eltQName = this.uriToPrefixMap.get(eltUri) + eltLocalName;
            }
            if (this.hasMappings) {
                AttributesImpl newAttrs = null;
                int mappingCount = this.prefixList.size();
                int attrCount = attrs.getLength();
                for (int mapping = 0; mapping < mappingCount; ++mapping) {
                    String uri = (String)this.uriList.get(mapping);
                    String prefix = (String)this.prefixList.get(mapping);
                    String qName = prefix.length() == 0 ? "xmlns" : "xmlns:" + prefix;
                    boolean found = false;
                    for (int attr = 0; attr < attrCount; ++attr) {
                        if (!qName.equals(attrs.getQName(attr))) continue;
                        if (!uri.equals(attrs.getValue(attr))) {
                            throw new SAXException("URI in prefix mapping and attribute do not match");
                        }
                        found = true;
                        break;
                    }
                    if (found) continue;
                    if (newAttrs == null) {
                        newAttrs = attrCount == 0 ? new AttributesImpl() : new AttributesImpl(attrs);
                    }
                    if (prefix.length() == 0) {
                        newAttrs.addAttribute(IOUtils.XML_NAMESPACE_URI, "xmlns", "xmlns", "CDATA", uri);
                        continue;
                    }
                    newAttrs.addAttribute(IOUtils.XML_NAMESPACE_URI, prefix, qName, "CDATA", uri);
                }
                this.clearMappings();
                this.contentHandler.startElement(eltUri, eltLocalName, eltQName, newAttrs == null ? attrs : newAttrs);
            } else {
                this.contentHandler.startElement(eltUri, eltLocalName, eltQName, attrs);
            }
        }

        public void endElement(String eltUri, String eltLocalName, String eltQName) throws SAXException {
            if (null != eltUri && eltUri.length() != 0 && this.uriToPrefixMap.containsKey(eltUri)) {
                eltQName = this.uriToPrefixMap.get(eltUri) + eltLocalName;
            }
            this.contentHandler.endElement(eltUri, eltLocalName, eltQName);
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            int pos;
            if (this.prefixToUriMap.containsKey(prefix)) {
                this.uriToPrefixMap.remove(this.prefixToUriMap.get(prefix));
                this.prefixToUriMap.remove(prefix);
            }
            if (this.hasMappings && (pos = this.prefixList.lastIndexOf(prefix)) != -1) {
                this.prefixList.remove(pos);
                this.uriList.remove(pos);
            }
            this.contentHandler.endPrefixMapping(prefix);
        }

        public void endDocument() throws SAXException {
            this.uriToPrefixMap.clear();
            this.prefixToUriMap.clear();
            this.clearMappings();
            this.contentHandler.endDocument();
        }

        private void clearMappings() {
            this.hasMappings = false;
            this.prefixList.clear();
            this.uriList.clear();
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.contentHandler.characters(ch, start, length);
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.contentHandler.ignorableWhitespace(ch, start, length);
        }

        public void processingInstruction(String target, String data) throws SAXException {
            this.contentHandler.processingInstruction(target, data);
        }

        public void setDocumentLocator(Locator locator) {
            this.contentHandler.setDocumentLocator(locator);
        }

        public void skippedEntity(String name) throws SAXException {
            this.contentHandler.skippedEntity(name);
        }
    }
}

