/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.ds;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.felix.scrplugin.SCRDescriptorException;
import org.apache.felix.scrplugin.SCRDescriptorFailureException;
import org.apache.felix.scrplugin.SpecVersion;
import org.apache.felix.scrplugin.annotations.AnnotationProcessor;
import org.apache.felix.scrplugin.annotations.ClassAnnotation;
import org.apache.felix.scrplugin.annotations.MethodAnnotation;
import org.apache.felix.scrplugin.annotations.ScannedAnnotation;
import org.apache.felix.scrplugin.annotations.ScannedClass;
import org.apache.felix.scrplugin.description.AbstractDescription;
import org.apache.felix.scrplugin.description.ClassDescription;
import org.apache.felix.scrplugin.description.ComponentConfigurationPolicy;
import org.apache.felix.scrplugin.description.ComponentDescription;
import org.apache.felix.scrplugin.description.PropertyDescription;
import org.apache.felix.scrplugin.description.PropertyType;
import org.apache.felix.scrplugin.description.PropertyUnbounded;
import org.apache.felix.scrplugin.description.ReferenceCardinality;
import org.apache.felix.scrplugin.description.ReferenceDescription;
import org.apache.felix.scrplugin.description.ReferencePolicy;
import org.apache.felix.scrplugin.description.ReferencePolicyOption;
import org.apache.felix.scrplugin.description.ReferenceStrategy;
import org.apache.felix.scrplugin.description.ServiceDescription;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSAnnotationProcessor
implements AnnotationProcessor {
    public String getName() {
        return "DS Annotation Processor";
    }

    public void process(ScannedClass scannedClass, ClassDescription describedClass) throws SCRDescriptorFailureException, SCRDescriptorException {
        List componentTags = scannedClass.getClassAnnotations(Component.class.getName());
        scannedClass.processed((Collection)componentTags);
        for (ClassAnnotation cad : componentTags) {
            this.createComponent(cad, describedClass, scannedClass);
        }
        List componentDescs = describedClass.getDescriptions(ComponentDescription.class);
        ComponentDescription found = null;
        if (!componentDescs.isEmpty()) {
            found = (ComponentDescription)componentDescs.get(0);
        }
        if (found != null) {
            ComponentDescription cd = found;
            List methodTags = scannedClass.getMethodAnnotations(null);
            for (MethodAnnotation m : methodTags) {
                if (m.getName().equals(Activate.class.getName())) {
                    cd.setActivate(m.getAnnotatedMethod().getName());
                    scannedClass.processed((ScannedAnnotation)m);
                    continue;
                }
                if (m.getName().equals(Deactivate.class.getName())) {
                    cd.setDeactivate(m.getAnnotatedMethod().getName());
                    scannedClass.processed((ScannedAnnotation)m);
                    continue;
                }
                if (m.getName().equals(Modified.class.getName())) {
                    cd.setModified(m.getAnnotatedMethod().getName());
                    scannedClass.processed((ScannedAnnotation)m);
                    continue;
                }
                if (!m.getName().equals(Reference.class.getName())) continue;
                this.processReference(describedClass, m);
                scannedClass.processed((ScannedAnnotation)m);
            }
        }
    }

    public int getRanking() {
        return 300;
    }

    private ComponentDescription createComponent(ClassAnnotation cad, ClassDescription describedClass, ScannedClass scannedClass) throws SCRDescriptorException {
        String[] property;
        ComponentDescription component = new ComponentDescription((ScannedAnnotation)cad);
        describedClass.add((AbstractDescription)component);
        boolean classIsAbstract = Modifier.isAbstract(scannedClass.getClass().getModifiers());
        component.setAbstract(classIsAbstract);
        component.setName(cad.getStringValue("name", scannedClass.getScannedClass().getName()));
        ArrayList<String> listedInterfaces = new ArrayList<String>();
        if (cad.hasValue("service")) {
            String[] interfaces = (String[])cad.getValue("service");
            if (interfaces != null) {
                for (String t : interfaces) {
                    listedInterfaces.add(t);
                }
            }
        } else {
            this.searchInterfaces(listedInterfaces, scannedClass.getScannedClass());
        }
        if (listedInterfaces.size() > 0) {
            ServiceDescription serviceDesc = new ServiceDescription((ScannedAnnotation)cad);
            describedClass.add((AbstractDescription)serviceDesc);
            for (String name : listedInterfaces) {
                serviceDesc.addInterface(name);
            }
            serviceDesc.setServiceFactory(cad.getBooleanValue("servicefactory", false));
        }
        component.setFactory(cad.getStringValue("factory", null));
        if (cad.getValue("enabled") != null) {
            component.setEnabled(Boolean.valueOf(cad.getBooleanValue("enabled", true)));
        }
        if (cad.getValue("immediate") != null) {
            component.setImmediate(Boolean.valueOf(cad.getBooleanValue("immediate", false)));
        }
        if ((property = (String[])cad.getValue("property")) != null) {
            for (String propDef : property) {
                int pos = propDef.indexOf(61);
                if (pos == -1) continue;
                String prefix = propDef.substring(0, pos);
                String value = propDef.substring(pos + 1);
                int typeSep = prefix.indexOf(58);
                String key = typeSep == -1 ? prefix : prefix.substring(0, typeSep);
                String type = typeSep == -1 ? PropertyType.String.name() : prefix.substring(typeSep + 1);
                PropertyType propType = PropertyType.valueOf((String)type);
                List existingProps = describedClass.getDescriptions(PropertyDescription.class);
                PropertyDescription found = null;
                for (PropertyDescription current : existingProps) {
                    if (!current.getName().equals(key)) continue;
                    found = current;
                    break;
                }
                if (found == null) {
                    PropertyDescription pd = new PropertyDescription((ScannedAnnotation)cad);
                    describedClass.add((AbstractDescription)pd);
                    pd.setName(key);
                    pd.setValue(value);
                    pd.setType(propType);
                    pd.setUnbounded(PropertyUnbounded.DEFAULT);
                    continue;
                }
                if (propType != found.getType()) {
                    throw new SCRDescriptorException("Multi value property '" + key + "' has different types: " + found.getType() + " & " + propType, describedClass.getSource());
                }
                if (found.getValue() != null) {
                    String[] values = new String[]{found.getValue(), value};
                    found.setMultiValue(values);
                    continue;
                }
                String[] oldValues = found.getMultiValue();
                String[] newValues = new String[oldValues.length + 1];
                System.arraycopy(oldValues, 0, newValues, 0, oldValues.length);
                newValues[oldValues.length] = value;
                found.setMultiValue(newValues);
            }
        }
        if (cad.getValue("xmlns") != null) {
            SpecVersion spec = SpecVersion.fromNamespaceUrl((String)cad.getValue("xmlns").toString());
            if (spec == null) {
                throw new SCRDescriptorException("Unknown xmlns attribute value: " + cad.getValue("xmlns"), describedClass.getSource());
            }
            component.setSpecVersion(spec);
        }
        component.setConfigurationPolicy(ComponentConfigurationPolicy.valueOf((String)cad.getEnumValue("configurationPolicy", ComponentConfigurationPolicy.OPTIONAL.name())));
        component.setConfigurationPid(cad.getStringValue("configurationPid", null));
        component.setCreatePid(false);
        component.setInherit(false);
        return component;
    }

    private void searchInterfaces(List<String> interfaceList, Class<?> javaClass) {
        Class<?>[] interfaces;
        for (Class<?> i : interfaces = javaClass.getInterfaces()) {
            interfaceList.add(i.getName());
        }
    }

    private void processReference(ClassDescription describedClass, MethodAnnotation ad) {
        String updated;
        String defaultUnbindMethodName;
        String refNameByMethod;
        ReferenceDescription ref = new ReferenceDescription((ScannedAnnotation)ad);
        describedClass.add((AbstractDescription)ref);
        ref.setStrategy(ReferenceStrategy.EVENT);
        String methodName = ad.getAnnotatedMethod().getName();
        if (methodName.startsWith("add")) {
            refNameByMethod = methodName.substring(3);
            defaultUnbindMethodName = "remove" + refNameByMethod;
        } else if (methodName.startsWith("set")) {
            refNameByMethod = methodName.substring(3);
            defaultUnbindMethodName = "unset" + refNameByMethod;
        } else if (methodName.startsWith("bind")) {
            refNameByMethod = methodName.substring(4);
            defaultUnbindMethodName = "unbind" + refNameByMethod;
        } else {
            refNameByMethod = methodName;
            defaultUnbindMethodName = "un" + refNameByMethod;
        }
        String defaultUpdateMethodName = "updated" + refNameByMethod;
        ref.setBind(ad.getAnnotatedMethod().getName());
        String unbind = ad.getStringValue("unbind", this.hasMethod(describedClass, defaultUnbindMethodName) ? defaultUnbindMethodName : "-");
        if (!unbind.equals("-")) {
            ref.setUnbind(unbind);
        }
        if (!(updated = ad.getStringValue("updated", this.hasMethod(describedClass, defaultUpdateMethodName) ? defaultUpdateMethodName : "-")).equals("-")) {
            ref.setUpdated(updated);
        }
        ref.setName(ad.getStringValue("name", refNameByMethod));
        String serviceName = ad.getStringValue("service", null);
        if (serviceName != null) {
            ref.setInterfaceName(serviceName);
        } else {
            Class<?>[] params = ad.getAnnotatedMethod().getParameterTypes();
            if (params != null && params.length > 0) {
                ref.setInterfaceName(params[0].getName());
            }
        }
        String cardinality = ad.getEnumValue("cardinality", "MANDATORY");
        if (cardinality.equals("OPTIONAL")) {
            ref.setCardinality(ReferenceCardinality.OPTIONAL_UNARY);
        } else if (cardinality.equals("MULTIPLE")) {
            ref.setCardinality(ReferenceCardinality.OPTIONAL_MULTIPLE);
        } else if (cardinality.equals("AT_LEAST_ONE")) {
            ref.setCardinality(ReferenceCardinality.MANDATORY_MULTIPLE);
        } else {
            ref.setCardinality(ReferenceCardinality.MANDATORY_UNARY);
        }
        ref.setPolicy(ReferencePolicy.valueOf((String)ad.getEnumValue("policy", ReferencePolicy.STATIC.name())));
        ref.setPolicyOption(ReferencePolicyOption.valueOf((String)ad.getEnumValue("policyOption", ReferencePolicyOption.RELUCTANT.name())));
        ref.setTarget(ad.getStringValue("target", null));
    }

    private boolean hasMethod(ClassDescription classDescription, String name) {
        Method[] allMethods;
        for (Method m : allMethods = classDescription.getDescribedClass().getDeclaredMethods()) {
            if (!m.getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

