/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.blob;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SubStream
extends InputStream {
    private final Object lock;
    private InputStream wrappedStream;
    private long substreamCurrentIndex;
    private long streamBeginIndex;
    private long streamLength;
    private long markIndex;
    private byte[] readBuffer;
    private ByteArrayInputStream readBufferStream;
    private int readBufferLength;

    public SubStream(InputStream source, long startIndex, long streamLength, Object lock) {
        if (startIndex < 0L || streamLength < 1L) {
            throw new IndexOutOfBoundsException();
        }
        if (source == null) {
            throw new NullPointerException("Source stream is null.");
        }
        if (!source.markSupported()) {
            throw new IllegalArgumentException("The source stream to be wrapped must be markable.");
        }
        this.wrappedStream = source;
        this.streamBeginIndex = startIndex;
        this.substreamCurrentIndex = 0L;
        this.streamLength = streamLength;
        this.lock = lock;
        this.readBuffer = new byte[0x400000];
        this.readBufferStream = new ByteArrayInputStream(this.readBuffer);
        this.readBufferLength = 0;
        this.markIndex = 0L;
        this.readBufferStream.mark(Integer.MAX_VALUE);
    }

    public InputStream getInputStream() {
        return this.wrappedStream;
    }

    public long getLength() {
        return this.streamLength;
    }

    @Override
    public int read() throws IOException {
        throw new IOException();
    }

    @Override
    public synchronized int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int bytesRead = -1;
        int readLength = len;
        if (this.substreamCurrentIndex + (long)len > this.streamLength) {
            readLength = (int)(this.streamLength - this.substreamCurrentIndex);
        }
        int bytesFromBuffer = this.readBufferStream.read(b, off, Math.min(this.readBufferLength, readLength));
        bytesRead = Math.max(0, bytesFromBuffer);
        this.readBufferLength -= bytesRead;
        if (bytesFromBuffer == readLength) {
            this.substreamCurrentIndex += (long)bytesRead;
            return bytesRead;
        }
        if (bytesFromBuffer < readLength) {
            this.readBufferStream.reset();
            this.readBufferLength = this.readHelper(this.readBuffer, 0, this.readBuffer.length);
            if (this.readBufferLength == -1) {
                this.readBufferLength = 0;
            }
        }
        if ((bytesFromBuffer = this.readBufferStream.read(b, bytesRead + off, Math.min(this.readBufferLength, readLength - bytesRead))) != -1) {
            bytesRead += bytesFromBuffer;
            this.readBufferLength -= bytesFromBuffer;
        }
        this.substreamCurrentIndex += (long)bytesRead;
        return bytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readHelper(byte[] b, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.wrappedStream.reset();
            long bytesSkipped = 0L;
            int failSkipCount = 0;
            long streamCurrentIndex = this.streamBeginIndex + this.substreamCurrentIndex;
            do {
                if (failSkipCount > 7) {
                    throw new IOException("The supplied stream has failed to skip to the correct position after successive attempts. Please ensure there are bytes available and try your upload again.");
                }
                long skipped = this.wrappedStream.skip(streamCurrentIndex - bytesSkipped);
                if (skipped == 0L) {
                    failSkipCount = (byte)(failSkipCount + 1);
                    continue;
                }
                failSkipCount = 0;
                bytesSkipped += skipped;
            } while (bytesSkipped != streamCurrentIndex);
            return this.wrappedStream.read(b, off, len);
        }
    }

    @Override
    public long skip(long n) {
        if (this.substreamCurrentIndex + n > this.streamLength) {
            n = this.streamLength - this.substreamCurrentIndex;
        }
        this.substreamCurrentIndex += n;
        this.readBufferLength = (int)Math.max(0L, (long)this.readBufferLength - n);
        return n;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.markIndex = this.substreamCurrentIndex;
    }

    @Override
    public synchronized void reset() {
        this.substreamCurrentIndex = this.markIndex;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void close() throws IOException {
        this.wrappedStream = null;
        this.readBuffer = null;
        this.readBufferStream.close();
        this.readBufferStream = null;
    }
}

