/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.queue;

import java.io.IOException;
import java.io.StringWriter;
import org.apache.flink.fs.azure.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.fs.azure.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.fs.azure.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.fs.azure.shaded.com.fasterxml.jackson.core.JsonToken;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.EncryptionData;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.JsonUtilities;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.Utility;

class CloudQueueEncryptedMessage {
    private String encryptedMessageContents;
    private EncryptionData encryptionData;

    CloudQueueEncryptedMessage() {
    }

    public String getEncryptedMessageContents() {
        return this.encryptedMessageContents;
    }

    public EncryptionData getEncryptionData() {
        return this.encryptionData;
    }

    public void setEncryptedMessageContents(String encryptedMessageContents) {
        this.encryptedMessageContents = encryptedMessageContents;
    }

    public void setEncryptionData(EncryptionData encryptionData) {
        this.encryptionData = encryptionData;
    }

    public String serialize() throws IOException {
        StringWriter strWriter = new StringWriter();
        JsonGenerator generator = Utility.getJsonGenerator(strWriter);
        try {
            generator.writeStartObject();
            generator.writeStringField("EncryptedMessageContents", this.getEncryptedMessageContents());
            generator.writeObjectFieldStart("EncryptionData");
            this.getEncryptionData().serialize(generator);
            generator.writeEndObject();
            generator.writeEndObject();
        }
        finally {
            generator.close();
        }
        return strWriter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloudQueueEncryptedMessage deserialize(String inputMessage) throws JsonProcessingException, IOException {
        JsonParser parser = Utility.getJsonParser(inputMessage);
        CloudQueueEncryptedMessage message = new CloudQueueEncryptedMessage();
        try {
            if (!parser.hasCurrentToken()) {
                parser.nextToken();
            }
            JsonUtilities.assertIsStartObjectJsonToken(parser);
            parser.nextToken();
            while (parser.getCurrentToken() != JsonToken.END_OBJECT) {
                String name = parser.getCurrentName();
                parser.nextToken();
                if (name.equals("EncryptedMessageContents")) {
                    message.setEncryptedMessageContents(parser.getValueAsString());
                } else if (name.equals("EncryptionData")) {
                    message.setEncryptionData(EncryptionData.deserialize(parser));
                }
                parser.nextToken();
            }
            JsonUtilities.assertIsEndObjectJsonToken(parser);
        }
        finally {
            parser.close();
        }
        return message;
    }
}

