/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.commons.configuration2;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.fs.shaded.hadoop3.org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.flink.fs.shaded.hadoop3.org.apache.commons.configuration2.event.EventListener;
import org.apache.flink.fs.shaded.hadoop3.org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.commons.lang3.StringUtils;

public class PropertiesConfigurationLayout
implements EventListener<ConfigurationEvent> {
    private static final String CR = "\n";
    private static final String COMMENT_PREFIX = "# ";
    private final Map<String, PropertyLayoutData> layoutData;
    private String headerComment;
    private String footerComment;
    private String globalSeparator;
    private String lineSeparator;
    private final AtomicInteger loadCounter = new AtomicInteger();
    private boolean forceSingleLine;

    public PropertiesConfigurationLayout() {
        this(null);
    }

    public PropertiesConfigurationLayout(PropertiesConfigurationLayout c) {
        this.layoutData = new LinkedHashMap<String, PropertyLayoutData>();
        if (c != null) {
            this.copyFrom(c);
        }
    }

    public String getCanonicalComment(String key, boolean commentChar) {
        return PropertiesConfigurationLayout.constructCanonicalComment(this.getComment(key), commentChar);
    }

    public String getComment(String key) {
        return this.fetchLayoutData(key).getComment();
    }

    public void setComment(String key, String comment) {
        this.fetchLayoutData(key).setComment(comment);
    }

    public int getBlancLinesBefore(String key) {
        return this.fetchLayoutData(key).getBlancLines();
    }

    public void setBlancLinesBefore(String key, int number) {
        this.fetchLayoutData(key).setBlancLines(number);
    }

    public String getCanonicalHeaderComment(boolean commentChar) {
        return PropertiesConfigurationLayout.constructCanonicalComment(this.getHeaderComment(), commentChar);
    }

    public String getHeaderComment() {
        return this.headerComment;
    }

    public void setHeaderComment(String comment) {
        this.headerComment = comment;
    }

    public String getCanonicalFooterCooment(boolean commentChar) {
        return PropertiesConfigurationLayout.constructCanonicalComment(this.getFooterComment(), commentChar);
    }

    public String getFooterComment() {
        return this.footerComment;
    }

    public void setFooterComment(String footerComment) {
        this.footerComment = footerComment;
    }

    public boolean isSingleLine(String key) {
        return this.fetchLayoutData(key).isSingleLine();
    }

    public void setSingleLine(String key, boolean f) {
        this.fetchLayoutData(key).setSingleLine(f);
    }

    public boolean isForceSingleLine() {
        return this.forceSingleLine;
    }

    public void setForceSingleLine(boolean f) {
        this.forceSingleLine = f;
    }

    public String getSeparator(String key) {
        return this.fetchLayoutData(key).getSeparator();
    }

    public void setSeparator(String key, String sep) {
        this.fetchLayoutData(key).setSeparator(sep);
    }

    public String getGlobalSeparator() {
        return this.globalSeparator;
    }

    public void setGlobalSeparator(String globalSeparator) {
        this.globalSeparator = globalSeparator;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public Set<String> getKeys() {
        return this.layoutData.keySet();
    }

    public void load(PropertiesConfiguration config, Reader in) throws ConfigurationException {
        this.loadCounter.incrementAndGet();
        PropertiesConfiguration.PropertiesReader reader = config.getIOFactory().createPropertiesReader(in);
        try {
            while (reader.nextProperty()) {
                if (!config.propertyLoaded(reader.getPropertyName(), reader.getPropertyValue())) continue;
                boolean contained = this.layoutData.containsKey(reader.getPropertyName());
                int blancLines = 0;
                int idx = this.checkHeaderComment(reader.getCommentLines());
                while (idx < reader.getCommentLines().size() && reader.getCommentLines().get(idx).length() < 1) {
                    ++idx;
                    ++blancLines;
                }
                String comment = this.extractComment(reader.getCommentLines(), idx, reader.getCommentLines().size() - 1);
                PropertyLayoutData data = this.fetchLayoutData(reader.getPropertyName());
                if (contained) {
                    data.addComment(comment);
                    data.setSingleLine(false);
                    continue;
                }
                data.setComment(comment);
                data.setBlancLines(blancLines);
                data.setSeparator(reader.getPropertySeparator());
            }
            this.setFooterComment(this.extractComment(reader.getCommentLines(), 0, reader.getCommentLines().size() - 1));
        }
        catch (IOException ioex) {
            throw new ConfigurationException(ioex);
        }
        finally {
            this.loadCounter.decrementAndGet();
        }
    }

    public void save(PropertiesConfiguration config, Writer out) throws ConfigurationException {
        try {
            PropertiesConfiguration.PropertiesWriter writer = config.getIOFactory().createPropertiesWriter(out, config.getListDelimiterHandler());
            writer.setGlobalSeparator(this.getGlobalSeparator());
            if (this.getLineSeparator() != null) {
                writer.setLineSeparator(this.getLineSeparator());
            }
            if (this.headerComment != null) {
                PropertiesConfigurationLayout.writeComment(writer, this.getCanonicalHeaderComment(true));
                writer.writeln(null);
            }
            for (String key : this.getKeys()) {
                if (!config.containsKeyInternal(key)) continue;
                for (int i = 0; i < this.getBlancLinesBefore(key); ++i) {
                    writer.writeln(null);
                }
                PropertiesConfigurationLayout.writeComment(writer, this.getCanonicalComment(key, true));
                boolean singleLine = this.isForceSingleLine() || this.isSingleLine(key);
                writer.setCurrentSeparator(this.getSeparator(key));
                writer.writeProperty(key, config.getPropertyInternal(key), singleLine);
            }
            PropertiesConfigurationLayout.writeComment(writer, this.getCanonicalFooterCooment(true));
            writer.flush();
        }
        catch (IOException ioex) {
            throw new ConfigurationException(ioex);
        }
    }

    @Override
    public void onEvent(ConfigurationEvent event) {
        if (!event.isBeforeUpdate() && this.loadCounter.get() == 0) {
            if (ConfigurationEvent.ADD_PROPERTY.equals(event.getEventType())) {
                boolean contained = this.layoutData.containsKey(event.getPropertyName());
                PropertyLayoutData data = this.fetchLayoutData(event.getPropertyName());
                data.setSingleLine(!contained);
            } else if (ConfigurationEvent.CLEAR_PROPERTY.equals(event.getEventType())) {
                this.layoutData.remove(event.getPropertyName());
            } else if (ConfigurationEvent.CLEAR.equals(event.getEventType())) {
                this.clear();
            } else if (ConfigurationEvent.SET_PROPERTY.equals(event.getEventType())) {
                this.fetchLayoutData(event.getPropertyName());
            }
        }
    }

    private PropertyLayoutData fetchLayoutData(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Property key must not be null!");
        }
        PropertyLayoutData data = this.layoutData.get(key);
        if (data == null) {
            data = new PropertyLayoutData();
            data.setSingleLine(true);
            this.layoutData.put(key, data);
        }
        return data;
    }

    private void clear() {
        this.layoutData.clear();
        this.setHeaderComment(null);
        this.setFooterComment(null);
    }

    static boolean isCommentLine(String line) {
        return PropertiesConfiguration.isCommentLine(line);
    }

    static String trimComment(String s2, boolean comment) {
        int pos;
        StringBuilder buf = new StringBuilder(s2.length());
        int lastPos = 0;
        do {
            if ((pos = s2.indexOf(CR, lastPos)) < 0) continue;
            String line = s2.substring(lastPos, pos);
            buf.append(PropertiesConfigurationLayout.stripCommentChar(line, comment)).append(CR);
            lastPos = pos + CR.length();
        } while (pos >= 0);
        if (lastPos < s2.length()) {
            buf.append(PropertiesConfigurationLayout.stripCommentChar(s2.substring(lastPos), comment));
        }
        return buf.toString();
    }

    static String stripCommentChar(String s2, boolean comment) {
        if (StringUtils.isBlank(s2) || PropertiesConfigurationLayout.isCommentLine(s2) == comment) {
            return s2;
        }
        if (!comment) {
            int pos = 0;
            while ("#!".indexOf(s2.charAt(pos)) < 0) {
                ++pos;
            }
            ++pos;
            while (pos < s2.length() && Character.isWhitespace(s2.charAt(pos))) {
                ++pos;
            }
            return pos < s2.length() ? s2.substring(pos) : "";
        }
        return COMMENT_PREFIX + s2;
    }

    private String extractComment(List<String> commentLines, int from, int to) {
        if (to < from) {
            return null;
        }
        StringBuilder buf = new StringBuilder(commentLines.get(from));
        for (int i = from + 1; i <= to; ++i) {
            buf.append(CR);
            buf.append(commentLines.get(i));
        }
        return buf.toString();
    }

    private int checkHeaderComment(List<String> commentLines) {
        if (this.loadCounter.get() == 1 && this.layoutData.isEmpty()) {
            int index;
            for (index = commentLines.size() - 1; index >= 0 && commentLines.get(index).length() > 0; --index) {
            }
            if (this.getHeaderComment() == null) {
                this.setHeaderComment(this.extractComment(commentLines, 0, index - 1));
            }
            return index + 1;
        }
        return 0;
    }

    private void copyFrom(PropertiesConfigurationLayout c) {
        for (String key : c.getKeys()) {
            PropertyLayoutData data = c.layoutData.get(key);
            this.layoutData.put(key, data.clone());
        }
        this.setHeaderComment(c.getHeaderComment());
        this.setFooterComment(c.getFooterComment());
    }

    private static void writeComment(PropertiesConfiguration.PropertiesWriter writer, String comment) throws IOException {
        if (comment != null) {
            writer.writeln(StringUtils.replace(comment, CR, writer.getLineSeparator()));
        }
    }

    private static String constructCanonicalComment(String comment, boolean commentChar) {
        return comment == null ? null : PropertiesConfigurationLayout.trimComment(comment, commentChar);
    }

    static class PropertyLayoutData
    implements Cloneable {
        private StringBuffer comment;
        private String separator = " = ";
        private int blancLines;
        private boolean singleLine = true;

        public int getBlancLines() {
            return this.blancLines;
        }

        public void setBlancLines(int blancLines) {
            this.blancLines = blancLines;
        }

        public boolean isSingleLine() {
            return this.singleLine;
        }

        public void setSingleLine(boolean singleLine) {
            this.singleLine = singleLine;
        }

        public void addComment(String s2) {
            if (s2 != null) {
                if (this.comment == null) {
                    this.comment = new StringBuffer(s2);
                } else {
                    this.comment.append(PropertiesConfigurationLayout.CR).append(s2);
                }
            }
        }

        public void setComment(String s2) {
            this.comment = s2 == null ? null : new StringBuffer(s2);
        }

        public String getComment() {
            return this.comment == null ? null : this.comment.toString();
        }

        public String getSeparator() {
            return this.separator;
        }

        public void setSeparator(String separator) {
            this.separator = separator;
        }

        public PropertyLayoutData clone() {
            try {
                PropertyLayoutData copy = (PropertyLayoutData)super.clone();
                if (this.comment != null) {
                    copy.comment = new StringBuffer(this.getComment());
                }
                return copy;
            }
            catch (CloneNotSupportedException cnex) {
                throw new ConfigurationRuntimeException(cnex);
            }
        }
    }
}

