/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.diagnostics;

import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidConfigurationValueException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.diagnostics.ConfigurationBasicValidator;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class BooleanConfigurationBasicValidator
extends ConfigurationBasicValidator<Boolean> {
    private static final String TRUE = "true";
    private static final String FALSE = "false";

    public BooleanConfigurationBasicValidator(String configKey, boolean defaultVal, boolean throwIfInvalid) {
        super(configKey, defaultVal, throwIfInvalid);
    }

    @Override
    public Boolean validate(String configValue) throws InvalidConfigurationValueException {
        Boolean result = (Boolean)super.validate(configValue);
        if (result != null) {
            return result;
        }
        if (configValue.equalsIgnoreCase(TRUE) || configValue.equalsIgnoreCase(FALSE)) {
            return Boolean.valueOf(configValue);
        }
        throw new InvalidConfigurationValueException(this.getConfigKey());
    }
}

