/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services;

import java.util.concurrent.ExecutorService;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services.AbfsLease;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services.AbfsOutputStreamStatistics;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services.AbfsOutputStreamStatisticsImpl;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services.AbfsStreamContext;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.store.DataBlocks;

public class AbfsOutputStreamContext
extends AbfsStreamContext {
    private int writeBufferSize;
    private boolean enableFlush;
    private boolean enableSmallWriteOptimization;
    private boolean disableOutputStreamFlush;
    private AbfsOutputStreamStatistics streamStatistics;
    private boolean isAppendBlob;
    private int writeMaxConcurrentRequestCount;
    private int maxWriteRequestsToQueue;
    private AbfsLease lease;
    private DataBlocks.BlockFactory blockFactory;
    private int blockOutputActiveBlocks;
    private AbfsClient client;
    private long position;
    private FileSystem.Statistics statistics;
    private String path;
    private ExecutorService executorService;
    private TracingContext tracingContext;

    public AbfsOutputStreamContext(long sasTokenRenewPeriodForStreamsInSeconds) {
        super(sasTokenRenewPeriodForStreamsInSeconds);
    }

    public AbfsOutputStreamContext withWriteBufferSize(int writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
        return this;
    }

    public AbfsOutputStreamContext enableFlush(boolean enableFlush) {
        this.enableFlush = enableFlush;
        return this;
    }

    public AbfsOutputStreamContext enableSmallWriteOptimization(boolean enableSmallWriteOptimization) {
        this.enableSmallWriteOptimization = enableSmallWriteOptimization;
        return this;
    }

    public AbfsOutputStreamContext disableOutputStreamFlush(boolean disableOutputStreamFlush) {
        this.disableOutputStreamFlush = disableOutputStreamFlush;
        return this;
    }

    public AbfsOutputStreamContext withStreamStatistics(AbfsOutputStreamStatistics streamStatistics) {
        this.streamStatistics = streamStatistics;
        return this;
    }

    public AbfsOutputStreamContext withAppendBlob(boolean isAppendBlob) {
        this.isAppendBlob = isAppendBlob;
        return this;
    }

    public AbfsOutputStreamContext withBlockFactory(DataBlocks.BlockFactory blockFactory) {
        this.blockFactory = blockFactory;
        return this;
    }

    public AbfsOutputStreamContext withBlockOutputActiveBlocks(int blockOutputActiveBlocks) {
        this.blockOutputActiveBlocks = blockOutputActiveBlocks;
        return this;
    }

    public AbfsOutputStreamContext withClient(AbfsClient client) {
        this.client = client;
        return this;
    }

    public AbfsOutputStreamContext withPosition(long position) {
        this.position = position;
        return this;
    }

    public AbfsOutputStreamContext withFsStatistics(FileSystem.Statistics statistics) {
        this.statistics = statistics;
        return this;
    }

    public AbfsOutputStreamContext withPath(String path) {
        this.path = path;
        return this;
    }

    public AbfsOutputStreamContext withExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public AbfsOutputStreamContext withTracingContext(TracingContext tracingContext) {
        this.tracingContext = tracingContext;
        return this;
    }

    public AbfsOutputStreamContext build() {
        if (this.streamStatistics == null) {
            this.streamStatistics = new AbfsOutputStreamStatisticsImpl();
        }
        return this;
    }

    public AbfsOutputStreamContext withWriteMaxConcurrentRequestCount(int writeMaxConcurrentRequestCount) {
        this.writeMaxConcurrentRequestCount = writeMaxConcurrentRequestCount;
        return this;
    }

    public AbfsOutputStreamContext withMaxWriteRequestsToQueue(int maxWriteRequestsToQueue) {
        this.maxWriteRequestsToQueue = maxWriteRequestsToQueue;
        return this;
    }

    public AbfsOutputStreamContext withLease(AbfsLease lease) {
        this.lease = lease;
        return this;
    }

    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public boolean isEnableFlush() {
        return this.enableFlush;
    }

    public boolean isDisableOutputStreamFlush() {
        return this.disableOutputStreamFlush;
    }

    public AbfsOutputStreamStatistics getStreamStatistics() {
        return this.streamStatistics;
    }

    public boolean isAppendBlob() {
        return this.isAppendBlob;
    }

    public int getWriteMaxConcurrentRequestCount() {
        return this.writeMaxConcurrentRequestCount;
    }

    public int getMaxWriteRequestsToQueue() {
        return this.maxWriteRequestsToQueue;
    }

    public boolean isEnableSmallWriteOptimization() {
        return this.enableSmallWriteOptimization;
    }

    public AbfsLease getLease() {
        return this.lease;
    }

    public String getLeaseId() {
        if (this.lease == null) {
            return null;
        }
        return this.lease.getLeaseID();
    }

    public DataBlocks.BlockFactory getBlockFactory() {
        return this.blockFactory;
    }

    public int getBlockOutputActiveBlocks() {
        return this.blockOutputActiveBlocks;
    }

    public AbfsClient getClient() {
        return this.client;
    }

    public FileSystem.Statistics getStatistics() {
        return this.statistics;
    }

    public String getPath() {
        return this.path;
    }

    public long getPosition() {
        return this.position;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public TracingContext getTracingContext() {
        return this.tracingContext;
    }
}

