/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.viewfs;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FsStatus;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.viewfs.InodeTree;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.viewfs.NotInMountpointException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.viewfs.ViewFileSystem;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.viewfs.ViewFileSystemOverloadScheme;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class ViewFileSystemUtil {
    private ViewFileSystemUtil() {
    }

    public static boolean isViewFileSystem(FileSystem fileSystem) {
        return fileSystem.getScheme().equals("viewfs");
    }

    public static boolean isViewFileSystemOverloadScheme(FileSystem fileSystem) {
        return fileSystem instanceof ViewFileSystemOverloadScheme;
    }

    public static Map<ViewFileSystem.MountPoint, FsStatus> getStatus(FileSystem fileSystem, Path path) throws IOException {
        if (!ViewFileSystemUtil.isViewFileSystem(fileSystem) && !ViewFileSystemUtil.isViewFileSystemOverloadScheme(fileSystem)) {
            throw new UnsupportedFileSystemException("FileSystem '" + fileSystem.getUri() + "'is not a ViewFileSystem.");
        }
        ViewFileSystem viewFileSystem = (ViewFileSystem)fileSystem;
        String viewFsUriPath = viewFileSystem.getUriPath(path);
        boolean isPathOverMountPoint = false;
        boolean isPathLeadingToMountPoint = false;
        boolean isPathIncludesAllMountPoint = false;
        HashMap<ViewFileSystem.MountPoint, FsStatus> mountPointMap = new HashMap<ViewFileSystem.MountPoint, FsStatus>();
        for (ViewFileSystem.MountPoint mountPoint : viewFileSystem.getMountPoints()) {
            int pathCompIndex;
            String[] mountPointPathComponents = InodeTree.breakIntoPathComponents(mountPoint.getMountedOnPath().toString());
            String[] incomingPathComponents = InodeTree.breakIntoPathComponents(viewFsUriPath);
            for (pathCompIndex = 0; pathCompIndex < mountPointPathComponents.length && pathCompIndex < incomingPathComponents.length && mountPointPathComponents[pathCompIndex].equals(incomingPathComponents[pathCompIndex]); ++pathCompIndex) {
            }
            if (pathCompIndex >= mountPointPathComponents.length) {
                isPathOverMountPoint = true;
                mountPointMap.clear();
                ViewFileSystemUtil.updateMountPointFsStatus(viewFileSystem, mountPointMap, mountPoint, new Path(viewFsUriPath));
                break;
            }
            if (pathCompIndex > 1) {
                isPathLeadingToMountPoint = true;
            } else if (incomingPathComponents.length <= 1) {
                isPathIncludesAllMountPoint = true;
            }
            ViewFileSystemUtil.updateMountPointFsStatus(viewFileSystem, mountPointMap, mountPoint, mountPoint.getMountedOnPath());
        }
        if (!(isPathOverMountPoint || isPathLeadingToMountPoint || isPathIncludesAllMountPoint)) {
            throw new NotInMountpointException(path, "getStatus");
        }
        return mountPointMap;
    }

    private static void updateMountPointFsStatus(ViewFileSystem viewFileSystem, Map<ViewFileSystem.MountPoint, FsStatus> mountPointMap, ViewFileSystem.MountPoint mountPoint, Path path) throws IOException {
        FsStatus fsStatus = viewFileSystem.getStatus(path);
        mountPointMap.put(mountPoint, fsStatus);
    }
}

