/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.compress.CodecPool;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.compress.Compressor;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.compress.Decompressor;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public interface CompressionCodec {
    public CompressionOutputStream createOutputStream(OutputStream var1) throws IOException;

    public CompressionOutputStream createOutputStream(OutputStream var1, Compressor var2) throws IOException;

    public Class<? extends Compressor> getCompressorType();

    public Compressor createCompressor();

    public CompressionInputStream createInputStream(InputStream var1) throws IOException;

    public CompressionInputStream createInputStream(InputStream var1, Decompressor var2) throws IOException;

    public Class<? extends Decompressor> getDecompressorType();

    public Decompressor createDecompressor();

    public String getDefaultExtension();

    public static class Util {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static CompressionOutputStream createOutputStreamWithCodecPool(CompressionCodec codec, Configuration conf, OutputStream out) throws IOException {
            Compressor compressor = CodecPool.getCompressor(codec, conf);
            CompressionOutputStream stream = null;
            try {
                stream = codec.createOutputStream(out, compressor);
            }
            finally {
                if (stream == null) {
                    CodecPool.returnCompressor(compressor);
                } else {
                    stream.setTrackedCompressor(compressor);
                }
            }
            return stream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static CompressionInputStream createInputStreamWithCodecPool(CompressionCodec codec, Configuration conf, InputStream in) throws IOException {
            Decompressor decompressor = CodecPool.getDecompressor(codec);
            CompressionInputStream stream = null;
            try {
                stream = codec.createInputStream(in, decompressor);
            }
            finally {
                if (stream == null) {
                    CodecPool.returnDecompressor(decompressor);
                } else {
                    stream.setTrackedDecompressor(decompressor);
                }
            }
            return stream;
        }
    }
}

