/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.erasurecode;

import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.erasurecode.ECBlock;

@InterfaceAudience.Private
public class ECBlockGroup {
    private ECBlock[] dataBlocks;
    private ECBlock[] parityBlocks;

    public ECBlockGroup(ECBlock[] dataBlocks, ECBlock[] parityBlocks) {
        this.dataBlocks = dataBlocks;
        this.parityBlocks = parityBlocks;
    }

    public ECBlock[] getDataBlocks() {
        return this.dataBlocks;
    }

    public ECBlock[] getParityBlocks() {
        return this.parityBlocks;
    }

    public boolean anyErasedDataBlock() {
        for (int i = 0; i < this.dataBlocks.length; ++i) {
            if (!this.dataBlocks[i].isErased()) continue;
            return true;
        }
        return false;
    }

    public boolean anyErasedParityBlock() {
        for (int i = 0; i < this.parityBlocks.length; ++i) {
            if (!this.parityBlocks[i].isErased()) continue;
            return true;
        }
        return false;
    }

    public int getErasedCount() {
        int erasedCount = 0;
        for (ECBlock dataBlock : this.dataBlocks) {
            if (!dataBlock.isErased()) continue;
            ++erasedCount;
        }
        for (ECBlock parityBlock : this.parityBlocks) {
            if (!parityBlock.isErased()) continue;
            ++erasedCount;
        }
        return erasedCount;
    }
}

