/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.PositionedReadable;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Seekable;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.statistics.IOStatisticsLogging;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class FSInputStream
extends InputStream
implements Seekable,
PositionedReadable {
    private static final Logger LOG = LoggerFactory.getLogger(FSInputStream.class);

    @Override
    public abstract void seek(long var1) throws IOException;

    @Override
    public abstract long getPos() throws IOException;

    @Override
    public abstract boolean seekToNewSource(long var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        this.validatePositionedReadArgs(position, buffer, offset, length);
        if (length == 0) {
            return 0;
        }
        FSInputStream fSInputStream = this;
        synchronized (fSInputStream) {
            long oldPos = this.getPos();
            int nread = -1;
            try {
                this.seek(position);
                nread = this.read(buffer, offset, length);
            }
            catch (EOFException e) {
                LOG.debug("Downgrading EOFException raised trying to read {} bytes at offset {}", new Object[]{length, offset, e});
            }
            finally {
                this.seek(oldPos);
            }
            return nread;
        }
    }

    protected void validatePositionedReadArgs(long position, byte[] buffer, int offset, int length) throws EOFException {
        Preconditions.checkArgument(length >= 0, "length is negative");
        if (position < 0L) {
            throw new EOFException("position is negative");
        }
        Preconditions.checkArgument(buffer != null, "Null buffer");
        if (buffer.length - offset < length) {
            throw new IndexOutOfBoundsException("Requested more bytes than destination buffer size: request length=" + length + ", with offset =" + offset + "; buffer capacity =" + (buffer.length - offset));
        }
    }

    @Override
    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        int nbytes;
        this.validatePositionedReadArgs(position, buffer, offset, length);
        for (int nread = 0; nread < length; nread += nbytes) {
            nbytes = this.read(position + (long)nread, buffer, offset + nread, length - nread);
            if (nbytes >= 0) continue;
            throw new EOFException("End of file reached before reading fully.");
        }
    }

    @Override
    public void readFully(long position, byte[] buffer) throws IOException {
        this.readFully(position, buffer, 0, buffer.length);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append('{');
        if (this instanceof IOStatisticsSource) {
            sb.append(IOStatisticsLogging.ioStatisticsSourceToString((IOStatisticsSource)((Object)this)));
        }
        sb.append('}');
        return sb.toString();
    }
}

