/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.contracts.services.AbfsPerfLoggable;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services.AbfsPerfInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AbfsPerfTracker {
    private static final Logger LOG = LoggerFactory.getLogger(AbfsPerfTracker.class);
    private static final String HOST_NAME_KEY = "h";
    private static final String TIMESTAMP_KEY = "t";
    private static final String STORAGE_ACCOUNT_NAME_KEY = "a";
    private static final String CONTAINER_NAME_KEY = "c";
    private static final String CALLER_METHOD_NAME_KEY = "cr";
    private static final String CALLEE_METHOD_NAME_KEY = "ce";
    private static final String RESULT_KEY = "r";
    private static final String LATENCY_KEY = "l";
    private static final String LATENCY_SUM_KEY = "ls";
    private static final String LATENCY_COUNT_KEY = "lc";
    private static final String HTTP_STATUS_CODE_KEY = "s";
    private static final String ERROR_CODE_KEY = "e";
    private static final String CLIENT_REQUEST_ID_KEY = "ci";
    private static final String SERVER_REQUEST_ID_KEY = "ri";
    private static final String CONNECTION_TIME_KEY = "ct";
    private static final String SENDING_TIME_KEY = "st";
    private static final String RECEIVING_TIME_KEY = "rt";
    private static final String BYTES_SENT_KEY = "bs";
    private static final String BYTES_RECEIVED_KEY = "br";
    private static final String HTTP_METHOD_KEY = "m";
    private static final String HTTP_URL_KEY = "u";
    private static final String STRING_PLACEHOLDER = "%s";
    private final ConcurrentLinkedQueue<String> queue = new ConcurrentLinkedQueue();
    private boolean enabled = false;
    private String hostName;
    private String singletonLatencyReportingFormat;
    private String aggregateLatencyReportingFormat;

    public AbfsPerfTracker(String filesystemName, String accountName, AbfsConfiguration configuration) {
        this(filesystemName, accountName, configuration.shouldTrackLatency());
    }

    protected AbfsPerfTracker(String filesystemName, String accountName, boolean enabled) {
        this.enabled = enabled;
        LOG.debug("AbfsPerfTracker configuration: {}", (Object)enabled);
        if (enabled) {
            try {
                this.hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                this.hostName = "UnknownHost";
            }
            String commonReportingFormat = HOST_NAME_KEY + "=" + this.hostName + " " + TIMESTAMP_KEY + "=" + STRING_PLACEHOLDER + " " + STORAGE_ACCOUNT_NAME_KEY + "=" + accountName + " " + CONTAINER_NAME_KEY + "=" + filesystemName + " " + CALLER_METHOD_NAME_KEY + "=" + STRING_PLACEHOLDER + " " + CALLEE_METHOD_NAME_KEY + "=" + STRING_PLACEHOLDER + " " + RESULT_KEY + "=" + STRING_PLACEHOLDER + " " + LATENCY_KEY + "=" + STRING_PLACEHOLDER;
            this.singletonLatencyReportingFormat = commonReportingFormat + STRING_PLACEHOLDER;
            this.aggregateLatencyReportingFormat = commonReportingFormat + " " + LATENCY_SUM_KEY + "=" + STRING_PLACEHOLDER + " " + LATENCY_COUNT_KEY + "=" + STRING_PLACEHOLDER + STRING_PLACEHOLDER;
        }
    }

    public void trackInfo(AbfsPerfInfo perfInfo) {
        if (!this.enabled) {
            return;
        }
        if (this.isValidInstant(perfInfo.getAggregateStart()) && perfInfo.getAggregateCount() > 0L) {
            this.recordClientLatency(perfInfo.getTrackingStart(), perfInfo.getTrackingEnd(), perfInfo.getCallerName(), perfInfo.getCalleeName(), perfInfo.getSuccess(), perfInfo.getAggregateStart(), perfInfo.getAggregateCount(), perfInfo.getResult());
        } else {
            this.recordClientLatency(perfInfo.getTrackingStart(), perfInfo.getTrackingEnd(), perfInfo.getCallerName(), perfInfo.getCalleeName(), perfInfo.getSuccess(), perfInfo.getResult());
        }
    }

    public Instant getLatencyInstant() {
        if (!this.enabled) {
            return null;
        }
        return Instant.now();
    }

    private void recordClientLatency(Instant operationStart, Instant operationStop, String callerName, String calleeName, boolean success, AbfsPerfLoggable res) {
        Instant trackerStart = Instant.now();
        long latency = this.isValidInstant(operationStart) && this.isValidInstant(operationStop) ? Duration.between(operationStart, operationStop).toMillis() : -1L;
        String latencyDetails = String.format(this.singletonLatencyReportingFormat, Instant.now(), callerName, calleeName, success ? "Succeeded" : "Failed", latency, res == null ? "" : " " + res.getLogString());
        this.offerToQueue(trackerStart, latencyDetails);
    }

    private void recordClientLatency(Instant operationStart, Instant operationStop, String callerName, String calleeName, boolean success, Instant aggregateStart, long aggregateCount, AbfsPerfLoggable res) {
        Instant trackerStart = Instant.now();
        long latency = this.isValidInstant(operationStart) && this.isValidInstant(operationStop) ? Duration.between(operationStart, operationStop).toMillis() : -1L;
        long aggregateLatency = this.isValidInstant(aggregateStart) && this.isValidInstant(operationStop) ? Duration.between(aggregateStart, operationStop).toMillis() : -1L;
        String latencyDetails = String.format(this.aggregateLatencyReportingFormat, Instant.now(), callerName, calleeName, success ? "Succeeded" : "Failed", latency, aggregateLatency, aggregateCount, res == null ? "" : " " + res.getLogString());
        this.offerToQueue(trackerStart, latencyDetails);
    }

    public String getClientLatency() {
        if (!this.enabled) {
            return null;
        }
        Instant trackerStart = Instant.now();
        String latencyDetails = this.queue.poll();
        if (LOG.isDebugEnabled()) {
            Instant stop = Instant.now();
            long elapsed = Duration.between(trackerStart, stop).toMillis();
            LOG.debug("Dequeued latency info [{} ms]: {}", (Object)elapsed, (Object)latencyDetails);
        }
        return latencyDetails;
    }

    private void offerToQueue(Instant trackerStart, String latencyDetails) {
        this.queue.offer(latencyDetails);
        if (LOG.isDebugEnabled()) {
            Instant trackerStop = Instant.now();
            long elapsed = Duration.between(trackerStart, trackerStop).toMillis();
            LOG.debug("Queued latency info [{} ms]: {}", (Object)elapsed, (Object)latencyDetails);
        }
    }

    private boolean isValidInstant(Instant testInstant) {
        return testInstant != null && testInstant != Instant.MIN && testInstant != Instant.MAX;
    }
}

