/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.WritableComparable;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.WritableComparator;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ShortWritable
implements WritableComparable<ShortWritable> {
    private short value;

    public ShortWritable() {
    }

    public ShortWritable(short value) {
        this.set(value);
    }

    public void set(short value) {
        this.value = value;
    }

    public short get() {
        return this.value;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.value = in.readShort();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeShort(this.value);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ShortWritable)) {
            return false;
        }
        ShortWritable other = (ShortWritable)o;
        return this.value == other.value;
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public int compareTo(ShortWritable o) {
        short thisValue = this.value;
        short thatValue = o.value;
        return thisValue < thatValue ? -1 : (thisValue == thatValue ? 0 : 1);
    }

    public String toString() {
        return Short.toString(this.value);
    }

    static {
        WritableComparator.define(ShortWritable.class, new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(ShortWritable.class);
        }

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            short thatValue;
            short thisValue = (short)Comparator.readUnsignedShort(b1, s1);
            return thisValue < (thatValue = (short)Comparator.readUnsignedShort(b2, s2)) ? -1 : (thisValue == thatValue ? 0 : 1);
        }
    }
}

