/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.erasurecode;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.erasurecode.rawcoder.NativeRSRawErasureCoderFactory;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.erasurecode.rawcoder.NativeXORRawErasureCoderFactory;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.erasurecode.rawcoder.RawErasureCoderFactory;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class CodecRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(CodecRegistry.class);
    private static CodecRegistry instance = new CodecRegistry();
    private Map<String, List<RawErasureCoderFactory>> coderMap = new HashMap<String, List<RawErasureCoderFactory>>();
    private Map<String, String[]> coderNameMap = new HashMap<String, String[]>();
    private HashMap<String, String> coderNameCompactMap = new HashMap();

    public static CodecRegistry getInstance() {
        return instance;
    }

    private CodecRegistry() {
        ServiceLoader<RawErasureCoderFactory> coderFactories = ServiceLoader.load(RawErasureCoderFactory.class);
        this.updateCoders(coderFactories);
    }

    @VisibleForTesting
    void updateCoders(Iterable<RawErasureCoderFactory> coderFactories) {
        List coders;
        String codecName;
        for (RawErasureCoderFactory rawErasureCoderFactory : coderFactories) {
            codecName = rawErasureCoderFactory.getCodecName();
            coders = this.coderMap.get(codecName);
            if (coders == null) {
                coders = new ArrayList<RawErasureCoderFactory>();
                coders.add((RawErasureCoderFactory)rawErasureCoderFactory);
                this.coderMap.put(codecName, coders);
                LOG.debug("Codec registered: codec = {}, coder = {}", (Object)rawErasureCoderFactory.getCodecName(), (Object)rawErasureCoderFactory.getCoderName());
                continue;
            }
            Boolean hasConflit = false;
            for (RawErasureCoderFactory coder : coders) {
                if (!coder.getCoderName().equals(rawErasureCoderFactory.getCoderName())) continue;
                hasConflit = true;
                LOG.error("Coder {} cannot be registered because its coder name {} has conflict with {}", new Object[]{rawErasureCoderFactory.getClass().getName(), rawErasureCoderFactory.getCoderName(), coder.getClass().getName()});
                break;
            }
            if (hasConflit.booleanValue()) continue;
            if (rawErasureCoderFactory instanceof NativeRSRawErasureCoderFactory || rawErasureCoderFactory instanceof NativeXORRawErasureCoderFactory) {
                coders.add(0, rawErasureCoderFactory);
            } else {
                coders.add(rawErasureCoderFactory);
            }
            LOG.debug("Codec registered: codec = {}, coder = {}", (Object)rawErasureCoderFactory.getCodecName(), (Object)rawErasureCoderFactory.getCoderName());
        }
        this.coderNameMap.clear();
        for (Map.Entry entry : this.coderMap.entrySet()) {
            codecName = (String)entry.getKey();
            coders = (List)entry.getValue();
            this.coderNameMap.put(codecName, coders.stream().map(RawErasureCoderFactory::getCoderName).collect(Collectors.toList()).toArray(new String[0]));
            this.coderNameCompactMap.put(codecName, coders.stream().map(RawErasureCoderFactory::getCoderName).collect(Collectors.joining(", ")));
        }
    }

    public String[] getCoderNames(String codecName) {
        String[] coderNames = this.coderNameMap.get(codecName);
        return coderNames;
    }

    public List<RawErasureCoderFactory> getCoders(String codecName) {
        List<RawErasureCoderFactory> coders = this.coderMap.get(codecName);
        return coders;
    }

    public Set<String> getCodecNames() {
        return this.coderMap.keySet();
    }

    public RawErasureCoderFactory getCoderByName(String codecName, String coderName) {
        List<RawErasureCoderFactory> coders = this.getCoders(codecName);
        for (RawErasureCoderFactory coder : coders) {
            if (!coder.getCoderName().equals(coderName)) continue;
            return coder;
        }
        return null;
    }

    public Map<String, String> getCodec2CoderCompactMap() {
        return this.coderNameCompactMap;
    }
}

