/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import java.net.URL;
import java.util.List;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.ExecutionEnvironmentFactory;
import org.apache.flink.client.program.Client;
import org.apache.flink.client.program.ContextEnvironment;
import org.apache.flink.client.program.DetachedEnvironment;

public class ContextEnvironmentFactory
implements ExecutionEnvironmentFactory {
    private final Client client;
    private final List<URL> jarFilesToAttach;
    private final List<URL> classpathsToAttach;
    private final ClassLoader userCodeClassLoader;
    private final int defaultParallelism;
    private final boolean wait;
    private ExecutionEnvironment lastEnvCreated;
    private String savepointPath;

    public ContextEnvironmentFactory(Client client, List<URL> jarFilesToAttach, List<URL> classpathsToAttach, ClassLoader userCodeClassLoader, int defaultParallelism, boolean wait, String savepointPath) {
        this.client = client;
        this.jarFilesToAttach = jarFilesToAttach;
        this.classpathsToAttach = classpathsToAttach;
        this.userCodeClassLoader = userCodeClassLoader;
        this.defaultParallelism = defaultParallelism;
        this.wait = wait;
        this.savepointPath = savepointPath;
    }

    public ExecutionEnvironment createExecutionEnvironment() {
        if (!this.wait && this.lastEnvCreated != null) {
            throw new InvalidProgramException("Multiple enviornments cannot be created in detached mode");
        }
        ContextEnvironment contextEnvironment = this.lastEnvCreated = this.wait ? new ContextEnvironment(this.client, this.jarFilesToAttach, this.classpathsToAttach, this.userCodeClassLoader, this.savepointPath) : new DetachedEnvironment(this.client, this.jarFilesToAttach, this.classpathsToAttach, this.userCodeClassLoader, this.savepointPath);
        if (this.defaultParallelism > 0) {
            this.lastEnvCreated.setParallelism(this.defaultParallelism);
        }
        return this.lastEnvCreated;
    }

    public ExecutionEnvironment getLastEnvCreated() {
        return this.lastEnvCreated;
    }
}

