/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.java.This0AccessFinder;
import org.apache.flink.shaded.asm7.org.objectweb.asm.ClassReader;
import org.apache.flink.shaded.asm7.org.objectweb.asm.ClassVisitor;
import org.apache.flink.util.InstantiationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class ClosureCleaner {
    private static final Logger LOG = LoggerFactory.getLogger(ClosureCleaner.class);

    public static void clean(Object func, ExecutionConfig.ClosureCleanerLevel level, boolean checkSerializable) {
        ClosureCleaner.clean(func, level, checkSerializable, Collections.newSetFromMap(new IdentityHashMap()));
    }

    private static void clean(Object func, ExecutionConfig.ClosureCleanerLevel level, boolean checkSerializable, Set<Object> visited) {
        if (func == null) {
            return;
        }
        if (!visited.add(func)) {
            return;
        }
        Class<?> cls = func.getClass();
        if (ClassUtils.isPrimitiveOrWrapper(cls)) {
            return;
        }
        if (ClosureCleaner.usesCustomSerialization(cls)) {
            return;
        }
        boolean closureAccessed = false;
        for (Field f : cls.getDeclaredFields()) {
            Object fieldObject;
            if (f.getName().startsWith("this$")) {
                closureAccessed |= ClosureCleaner.cleanThis0(func, cls, f.getName());
                continue;
            }
            try {
                f.setAccessible(true);
                fieldObject = f.get(func);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(String.format("Can not access to the %s field in Class %s", f.getName(), func.getClass()));
            }
            if (level != ExecutionConfig.ClosureCleanerLevel.RECURSIVE || !ClosureCleaner.needsRecursion(f, fieldObject)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Dig to clean the {}", (Object)fieldObject.getClass().getName());
            }
            ClosureCleaner.clean(fieldObject, ExecutionConfig.ClosureCleanerLevel.RECURSIVE, true, visited);
        }
        if (checkSerializable) {
            try {
                InstantiationUtil.serializeObject((Object)func);
            }
            catch (Exception e) {
                String functionType = ClosureCleaner.getSuperClassOrInterfaceName(func.getClass());
                String msg = functionType == null ? func + " is not serializable." : "The implementation of the " + functionType + " is not serializable.";
                msg = closureAccessed ? msg + " The implementation accesses fields of its enclosing class, which is a common reason for non-serializability. A common solution is to make the function a proper (non-inner) class, or a static inner class." : msg + " The object probably contains or references non serializable fields.";
                throw new InvalidProgramException(msg, (Throwable)e);
            }
        }
    }

    private static boolean needsRecursion(Field f, Object fo) {
        return fo != null && !Modifier.isStatic(f.getModifiers()) && !Modifier.isTransient(f.getModifiers());
    }

    private static boolean usesCustomSerialization(Class<?> cls) {
        try {
            cls.getDeclaredMethod("writeObject", ObjectOutputStream.class);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                cls.getDeclaredMethod("writeReplace", new Class[0]);
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                return Externalizable.class.isAssignableFrom(cls);
            }
        }
    }

    public static void ensureSerializable(Object obj) {
        try {
            InstantiationUtil.serializeObject((Object)obj);
        }
        catch (Exception e) {
            throw new InvalidProgramException("Object " + obj + " is not serializable", (Throwable)e);
        }
    }

    private static boolean cleanThis0(Object func, Class<?> cls, String this0Name) {
        This0AccessFinder this0Finder = new This0AccessFinder(this0Name);
        ClosureCleaner.getClassReader(cls).accept((ClassVisitor)this0Finder, 0);
        boolean accessesClosure = this0Finder.isThis0Accessed();
        if (LOG.isDebugEnabled()) {
            LOG.debug(this0Name + " is accessed: " + accessesClosure);
        }
        if (!accessesClosure) {
            Field this0;
            try {
                this0 = func.getClass().getDeclaredField(this0Name);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("Could not set " + this0Name + ": " + e);
            }
            try {
                this0.setAccessible(true);
                this0.set(func, null);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not set " + this0Name + " to null. " + e.getMessage(), e);
            }
        }
        return accessesClosure;
    }

    private static ClassReader getClassReader(Class<?> cls) {
        String className = cls.getName().replaceFirst("^.*\\.", "") + ".class";
        try {
            return new ClassReader(cls.getResourceAsStream(className));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create ClassReader: " + e.getMessage(), e);
        }
    }

    private static String getSuperClassOrInterfaceName(Class<?> cls) {
        Class<?> superclass = cls.getSuperclass();
        if (superclass.getName().startsWith("org.apache.flink")) {
            return superclass.getSimpleName();
        }
        for (Class<?> inFace : cls.getInterfaces()) {
            if (!inFace.getName().startsWith("org.apache.flink")) continue;
            return inFace.getSimpleName();
        }
        return null;
    }
}

