/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java;

import org.apache.flink.annotation.Public;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.PlanExecutor;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Preconditions;

@Public
public class LocalEnvironment
extends ExecutionEnvironment {
    private final Configuration configuration;

    public LocalEnvironment() {
        this(new Configuration());
    }

    public LocalEnvironment(Configuration config) {
        if (!ExecutionEnvironment.areExplicitEnvironmentsAllowed()) {
            throw new InvalidProgramException("The LocalEnvironment cannot be instantiated when running in a pre-defined context (such as Command Line Client, Scala Shell, or TestEnvironment)");
        }
        this.configuration = (Configuration)Preconditions.checkNotNull((Object)config);
    }

    @Override
    public JobExecutionResult execute(String jobName) throws Exception {
        Plan p = this.createProgramPlan(jobName);
        PlanExecutor executor = PlanExecutor.createLocalExecutor((Configuration)this.configuration);
        this.lastJobExecutionResult = executor.executePlan(p);
        return this.lastJobExecutionResult;
    }

    public String toString() {
        return "Local Environment (parallelism = " + (this.getParallelism() == -1 ? "default" : Integer.valueOf(this.getParallelism())) + ").";
    }
}

