/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.decorators;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.kubeclient.FlinkPod;
import org.apache.flink.kubernetes.kubeclient.decorators.AbstractKubernetesStepDecorator;
import org.apache.flink.kubernetes.kubeclient.parameters.KubernetesJobManagerParameters;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesToleration;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Container;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerPort;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.EnvVar;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.EnvVarBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.EnvVarSourceBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ResourceRequirements;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Toleration;
import org.apache.flink.kubernetes.utils.KubernetesUtils;
import org.apache.flink.util.Preconditions;

public class InitJobManagerDecorator
extends AbstractKubernetesStepDecorator {
    private final KubernetesJobManagerParameters kubernetesJobManagerParameters;
    private final Configuration flinkConfig;

    public InitJobManagerDecorator(KubernetesJobManagerParameters kubernetesJobManagerParameters) {
        this.kubernetesJobManagerParameters = (KubernetesJobManagerParameters)Preconditions.checkNotNull((Object)kubernetesJobManagerParameters);
        this.flinkConfig = (Configuration)Preconditions.checkNotNull((Object)kubernetesJobManagerParameters.getFlinkConfiguration());
    }

    @Override
    public FlinkPod decorateFlinkPod(FlinkPod flinkPod) {
        PodBuilder basicPodBuilder = new PodBuilder(flinkPod.getPodWithoutMainContainer());
        String serviceAccountName = KubernetesUtils.resolveUserDefinedValue(this.flinkConfig, KubernetesConfigOptions.JOB_MANAGER_SERVICE_ACCOUNT, this.kubernetesJobManagerParameters.getServiceAccount(), KubernetesUtils.getServiceAccount(flinkPod), "service account");
        if (flinkPod.getPodWithoutMainContainer().getSpec().getRestartPolicy() != null) {
            this.logger.info("The restart policy of JobManager pod will be overwritten to 'always' since it is controlled by the Kubernetes deployment.");
        }
        ((PodFluent.SpecNested)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodBuilder)basicPodBuilder.withApiVersion("v1")).editOrNewSpec().withServiceAccount(serviceAccountName)).withServiceAccountName(serviceAccountName)).withHostNetwork(this.kubernetesJobManagerParameters.isHostNetworkEnabled())).withDnsPolicy(this.kubernetesJobManagerParameters.isHostNetworkEnabled() ? "ClusterFirstWithHostNet" : "ClusterFirst")).endSpec();
        ((PodFluent.SpecNested)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)basicPodBuilder.editOrNewMetadata().addToLabels(this.kubernetesJobManagerParameters.getLabels())).addToAnnotations(this.kubernetesJobManagerParameters.getAnnotations())).endMetadata()).editOrNewSpec().addToImagePullSecrets(this.kubernetesJobManagerParameters.getImagePullSecrets())).addToNodeSelector(this.kubernetesJobManagerParameters.getNodeSelector())).addAllToTolerations(this.kubernetesJobManagerParameters.getTolerations().stream().map(e -> (Toleration)KubernetesToleration.fromMap(e).getInternalResource()).collect(Collectors.toList()))).endSpec();
        Container basicMainContainer = this.decorateMainContainer(flinkPod.getMainContainer());
        return new FlinkPod.Builder(flinkPod).withPod(basicPodBuilder.build()).withMainContainer(basicMainContainer).build();
    }

    private Container decorateMainContainer(Container container) {
        ContainerBuilder mainContainerBuilder = new ContainerBuilder(container);
        String image = KubernetesUtils.resolveUserDefinedValue(this.flinkConfig, KubernetesConfigOptions.CONTAINER_IMAGE, this.kubernetesJobManagerParameters.getImage(), container.getImage(), "main container image");
        String imagePullPolicy = KubernetesUtils.resolveUserDefinedValue(this.flinkConfig, KubernetesConfigOptions.CONTAINER_IMAGE_PULL_POLICY, this.kubernetesJobManagerParameters.getImagePullPolicy().name(), container.getImagePullPolicy(), "main container image pull policy");
        ResourceRequirements requirementsInPodTemplate = container.getResources() == null ? new ResourceRequirements() : container.getResources();
        ResourceRequirements requirements = KubernetesUtils.getResourceRequirements(requirementsInPodTemplate, this.kubernetesJobManagerParameters.getJobManagerMemoryMB(), this.kubernetesJobManagerParameters.getJobManagerMemoryLimitFactor(), this.kubernetesJobManagerParameters.getJobManagerCPU(), this.kubernetesJobManagerParameters.getJobManagerCPULimitFactor(), Collections.emptyMap(), Collections.emptyMap());
        ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)mainContainerBuilder.withName("flink-main-container")).withImage(image)).withImagePullPolicy(imagePullPolicy)).withResources(requirements);
        ((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((ContainerBuilder)((ContainerBuilder)mainContainerBuilder.addAllToPorts(this.getContainerPorts())).addAllToEnv(this.getCustomizedEnvs())).addNewEnv().withName("_POD_IP_ADDRESS")).withValueFrom(((EnvVarSourceBuilder)new EnvVarSourceBuilder().withNewFieldRef("v1", "status.podIP")).build())).endEnv();
        this.getFlinkLogDirEnv().ifPresent(xva$0 -> mainContainerBuilder.addToEnv((EnvVar)xva$0));
        return mainContainerBuilder.build();
    }

    private List<ContainerPort> getContainerPorts() {
        if (this.kubernetesJobManagerParameters.isHostNetworkEnabled()) {
            return Collections.emptyList();
        }
        return Arrays.asList(((ContainerPortBuilder)((ContainerPortBuilder)new ContainerPortBuilder().withName("rest")).withContainerPort(this.kubernetesJobManagerParameters.getRestPort())).build(), ((ContainerPortBuilder)((ContainerPortBuilder)new ContainerPortBuilder().withName("jobmanager-rpc")).withContainerPort(this.kubernetesJobManagerParameters.getRPCPort())).build(), ((ContainerPortBuilder)((ContainerPortBuilder)new ContainerPortBuilder().withName("blobserver")).withContainerPort(this.kubernetesJobManagerParameters.getBlobServerPort())).build());
    }

    private List<EnvVar> getCustomizedEnvs() {
        return this.kubernetesJobManagerParameters.getEnvironments().entrySet().stream().map(kv -> ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName((String)kv.getKey())).withValue((String)kv.getValue())).build()).collect(Collectors.toList());
    }

    private Optional<EnvVar> getFlinkLogDirEnv() {
        return this.kubernetesJobManagerParameters.getFlinkLogDirInPod().map(logDir -> new EnvVar("FLINK_LOG_DIR", (String)logDir, null));
    }
}

