/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model;

import java.util.Objects;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.VisitableBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Binding;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.BindingFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.BindingFluentImpl;

public class BindingBuilder
extends BindingFluentImpl<BindingBuilder>
implements VisitableBuilder<Binding, BindingBuilder> {
    BindingFluent<?> fluent;
    Boolean validationEnabled;

    public BindingBuilder() {
        this(false);
    }

    public BindingBuilder(Boolean validationEnabled) {
        this(new Binding(), validationEnabled);
    }

    public BindingBuilder(BindingFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public BindingBuilder(BindingFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Binding(), validationEnabled);
    }

    public BindingBuilder(BindingFluent<?> fluent, Binding instance) {
        this(fluent, instance, false);
    }

    public BindingBuilder(BindingFluent<?> fluent, Binding instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withTarget(instance.getTarget());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public BindingBuilder(Binding instance) {
        this(instance, (Boolean)false);
    }

    public BindingBuilder(Binding instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withTarget(instance.getTarget());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Binding build() {
        Binding buildable = new Binding(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getTarget());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BindingBuilder that = (BindingBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

