/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apiextensions.v1beta1;

import java.util.Objects;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.VisitableBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidationFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidationFluentImpl;

public class CustomResourceValidationBuilder
extends CustomResourceValidationFluentImpl<CustomResourceValidationBuilder>
implements VisitableBuilder<CustomResourceValidation, CustomResourceValidationBuilder> {
    CustomResourceValidationFluent<?> fluent;
    Boolean validationEnabled;

    public CustomResourceValidationBuilder() {
        this(false);
    }

    public CustomResourceValidationBuilder(Boolean validationEnabled) {
        this(new CustomResourceValidation(), validationEnabled);
    }

    public CustomResourceValidationBuilder(CustomResourceValidationFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public CustomResourceValidationBuilder(CustomResourceValidationFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new CustomResourceValidation(), validationEnabled);
    }

    public CustomResourceValidationBuilder(CustomResourceValidationFluent<?> fluent, CustomResourceValidation instance) {
        this(fluent, instance, false);
    }

    public CustomResourceValidationBuilder(CustomResourceValidationFluent<?> fluent, CustomResourceValidation instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withOpenAPIV3Schema(instance.getOpenAPIV3Schema());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public CustomResourceValidationBuilder(CustomResourceValidation instance) {
        this(instance, (Boolean)false);
    }

    public CustomResourceValidationBuilder(CustomResourceValidation instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withOpenAPIV3Schema(instance.getOpenAPIV3Schema());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public CustomResourceValidation build() {
        CustomResourceValidation buildable = new CustomResourceValidation(this.fluent.getOpenAPIV3Schema());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomResourceValidationBuilder that = (CustomResourceValidationBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

