/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.metrics.v1beta1;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Duration;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ObjectMeta;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Quantity;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.metrics.v1beta1.NodeMetrics;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.metrics.v1beta1.NodeMetricsFluent;

public class NodeMetricsFluentImpl<A extends NodeMetricsFluent<A>>
extends BaseFluent<A>
implements NodeMetricsFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private String timestamp;
    private Map<String, Quantity> usage;
    private Duration window;
    private Map<String, Object> additionalProperties;

    public NodeMetricsFluentImpl() {
    }

    public NodeMetricsFluentImpl(NodeMetrics instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withTimestamp(instance.getTimestamp());
        this.withUsage(instance.getUsage());
        this.withWindow(instance.getWindow());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public NodeMetricsFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public NodeMetricsFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public NodeMetricsFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public NodeMetricsFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public NodeMetricsFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public String getTimestamp() {
        return this.timestamp;
    }

    @Override
    public A withTimestamp(String timestamp) {
        this.timestamp = timestamp;
        return (A)this;
    }

    @Override
    public Boolean hasTimestamp() {
        return this.timestamp != null;
    }

    @Override
    @Deprecated
    public A withNewTimestamp(String arg0) {
        return this.withTimestamp(new String(arg0));
    }

    @Override
    public A addToUsage(String key, Quantity value) {
        if (this.usage == null && key != null && value != null) {
            this.usage = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.usage.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToUsage(Map<String, Quantity> map) {
        if (this.usage == null && map != null) {
            this.usage = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.usage.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromUsage(String key) {
        if (this.usage == null) {
            return (A)this;
        }
        if (key != null && this.usage != null) {
            this.usage.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromUsage(Map<String, Quantity> map) {
        if (this.usage == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.usage == null) continue;
                this.usage.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getUsage() {
        return this.usage;
    }

    @Override
    public <K, V> A withUsage(Map<String, Quantity> usage) {
        this.usage = usage == null ? null : new LinkedHashMap<String, Quantity>(usage);
        return (A)this;
    }

    @Override
    public Boolean hasUsage() {
        return this.usage != null;
    }

    @Override
    public Duration getWindow() {
        return this.window;
    }

    @Override
    public A withWindow(Duration window) {
        this.window = window;
        return (A)this;
    }

    @Override
    public Boolean hasWindow() {
        return this.window != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeMetricsFluentImpl that = (NodeMetricsFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.timestamp != null ? !this.timestamp.equals(that.timestamp) : that.timestamp != null) {
            return false;
        }
        if (this.usage != null ? !this.usage.equals(that.usage) : that.usage != null) {
            return false;
        }
        if (this.window != null ? !this.window.equals(that.window) : that.window != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.timestamp, this.usage, this.window, this.additionalProperties, super.hashCode());
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<NodeMetricsFluent.MetadataNested<N>>
    implements NodeMetricsFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)NodeMetricsFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

