/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.networking.v1;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.LabelSelector;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyEgressRule;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyEgressRuleBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyEgressRuleFluentImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRule;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRuleBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRuleFluentImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicySpec;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicySpecFluent;

public class NetworkPolicySpecFluentImpl<A extends NetworkPolicySpecFluent<A>>
extends BaseFluent<A>
implements NetworkPolicySpecFluent<A> {
    private List<NetworkPolicyEgressRuleBuilder> egress = new ArrayList<NetworkPolicyEgressRuleBuilder>();
    private List<NetworkPolicyIngressRuleBuilder> ingress = new ArrayList<NetworkPolicyIngressRuleBuilder>();
    private LabelSelectorBuilder podSelector;
    private List<String> policyTypes = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public NetworkPolicySpecFluentImpl() {
    }

    public NetworkPolicySpecFluentImpl(NetworkPolicySpec instance) {
        this.withEgress(instance.getEgress());
        this.withIngress(instance.getIngress());
        this.withPodSelector(instance.getPodSelector());
        this.withPolicyTypes(instance.getPolicyTypes());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToEgress(Integer index, NetworkPolicyEgressRule item) {
        if (this.egress == null) {
            this.egress = new ArrayList<NetworkPolicyEgressRuleBuilder>();
        }
        NetworkPolicyEgressRuleBuilder builder = new NetworkPolicyEgressRuleBuilder(item);
        this._visitables.get("egress").add(index >= 0 ? index.intValue() : this._visitables.get("egress").size(), builder);
        this.egress.add(index >= 0 ? index.intValue() : this.egress.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEgress(Integer index, NetworkPolicyEgressRule item) {
        if (this.egress == null) {
            this.egress = new ArrayList<NetworkPolicyEgressRuleBuilder>();
        }
        NetworkPolicyEgressRuleBuilder builder = new NetworkPolicyEgressRuleBuilder(item);
        if (index < 0 || index >= this._visitables.get("egress").size()) {
            this._visitables.get("egress").add(builder);
        } else {
            this._visitables.get("egress").set(index, builder);
        }
        if (index < 0 || index >= this.egress.size()) {
            this.egress.add(builder);
        } else {
            this.egress.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEgress(NetworkPolicyEgressRule ... items) {
        if (this.egress == null) {
            this.egress = new ArrayList<NetworkPolicyEgressRuleBuilder>();
        }
        for (NetworkPolicyEgressRule item : items) {
            NetworkPolicyEgressRuleBuilder builder = new NetworkPolicyEgressRuleBuilder(item);
            this._visitables.get("egress").add(builder);
            this.egress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEgress(Collection<NetworkPolicyEgressRule> items) {
        if (this.egress == null) {
            this.egress = new ArrayList<NetworkPolicyEgressRuleBuilder>();
        }
        for (NetworkPolicyEgressRule item : items) {
            NetworkPolicyEgressRuleBuilder builder = new NetworkPolicyEgressRuleBuilder(item);
            this._visitables.get("egress").add(builder);
            this.egress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEgress(NetworkPolicyEgressRule ... items) {
        for (NetworkPolicyEgressRule item : items) {
            NetworkPolicyEgressRuleBuilder builder = new NetworkPolicyEgressRuleBuilder(item);
            this._visitables.get("egress").remove(builder);
            if (this.egress == null) continue;
            this.egress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEgress(Collection<NetworkPolicyEgressRule> items) {
        for (NetworkPolicyEgressRule item : items) {
            NetworkPolicyEgressRuleBuilder builder = new NetworkPolicyEgressRuleBuilder(item);
            this._visitables.get("egress").remove(builder);
            if (this.egress == null) continue;
            this.egress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromEgress(Predicate<NetworkPolicyEgressRuleBuilder> predicate) {
        if (this.egress == null) {
            return (A)this;
        }
        Iterator<NetworkPolicyEgressRuleBuilder> each = this.egress.iterator();
        Object visitables = this._visitables.get("egress");
        while (each.hasNext()) {
            NetworkPolicyEgressRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<NetworkPolicyEgressRule> getEgress() {
        return NetworkPolicySpecFluentImpl.build(this.egress);
    }

    @Override
    public List<NetworkPolicyEgressRule> buildEgress() {
        return NetworkPolicySpecFluentImpl.build(this.egress);
    }

    @Override
    public NetworkPolicyEgressRule buildEgress(Integer index) {
        return this.egress.get(index).build();
    }

    @Override
    public NetworkPolicyEgressRule buildFirstEgress() {
        return this.egress.get(0).build();
    }

    @Override
    public NetworkPolicyEgressRule buildLastEgress() {
        return this.egress.get(this.egress.size() - 1).build();
    }

    @Override
    public NetworkPolicyEgressRule buildMatchingEgress(Predicate<NetworkPolicyEgressRuleBuilder> predicate) {
        for (NetworkPolicyEgressRuleBuilder item : this.egress) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEgress(Predicate<NetworkPolicyEgressRuleBuilder> predicate) {
        for (NetworkPolicyEgressRuleBuilder item : this.egress) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEgress(List<NetworkPolicyEgressRule> egress) {
        if (this.egress != null) {
            this._visitables.get("egress").removeAll(this.egress);
        }
        if (egress != null) {
            this.egress = new ArrayList<NetworkPolicyEgressRuleBuilder>();
            for (NetworkPolicyEgressRule item : egress) {
                this.addToEgress(item);
            }
        } else {
            this.egress = null;
        }
        return (A)this;
    }

    @Override
    public A withEgress(NetworkPolicyEgressRule ... egress) {
        if (this.egress != null) {
            this.egress.clear();
        }
        if (egress != null) {
            for (NetworkPolicyEgressRule item : egress) {
                this.addToEgress(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEgress() {
        return this.egress != null && !this.egress.isEmpty();
    }

    @Override
    public NetworkPolicySpecFluent.EgressNested<A> addNewEgress() {
        return new EgressNestedImpl();
    }

    @Override
    public NetworkPolicySpecFluent.EgressNested<A> addNewEgressLike(NetworkPolicyEgressRule item) {
        return new EgressNestedImpl(-1, item);
    }

    @Override
    public NetworkPolicySpecFluent.EgressNested<A> setNewEgressLike(Integer index, NetworkPolicyEgressRule item) {
        return new EgressNestedImpl(index, item);
    }

    @Override
    public NetworkPolicySpecFluent.EgressNested<A> editEgress(Integer index) {
        if (this.egress.size() <= index) {
            throw new RuntimeException("Can't edit egress. Index exceeds size.");
        }
        return this.setNewEgressLike(index, this.buildEgress(index));
    }

    @Override
    public NetworkPolicySpecFluent.EgressNested<A> editFirstEgress() {
        if (this.egress.size() == 0) {
            throw new RuntimeException("Can't edit first egress. The list is empty.");
        }
        return this.setNewEgressLike(0, this.buildEgress(0));
    }

    @Override
    public NetworkPolicySpecFluent.EgressNested<A> editLastEgress() {
        int index = this.egress.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last egress. The list is empty.");
        }
        return this.setNewEgressLike(index, this.buildEgress(index));
    }

    @Override
    public NetworkPolicySpecFluent.EgressNested<A> editMatchingEgress(Predicate<NetworkPolicyEgressRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.egress.size(); ++i) {
            if (!predicate.test(this.egress.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching egress. No match found.");
        }
        return this.setNewEgressLike(index, this.buildEgress(index));
    }

    @Override
    public A addToIngress(Integer index, NetworkPolicyIngressRule item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList<NetworkPolicyIngressRuleBuilder>();
        }
        NetworkPolicyIngressRuleBuilder builder = new NetworkPolicyIngressRuleBuilder(item);
        this._visitables.get("ingress").add(index >= 0 ? index.intValue() : this._visitables.get("ingress").size(), builder);
        this.ingress.add(index >= 0 ? index.intValue() : this.ingress.size(), builder);
        return (A)this;
    }

    @Override
    public A setToIngress(Integer index, NetworkPolicyIngressRule item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList<NetworkPolicyIngressRuleBuilder>();
        }
        NetworkPolicyIngressRuleBuilder builder = new NetworkPolicyIngressRuleBuilder(item);
        if (index < 0 || index >= this._visitables.get("ingress").size()) {
            this._visitables.get("ingress").add(builder);
        } else {
            this._visitables.get("ingress").set(index, builder);
        }
        if (index < 0 || index >= this.ingress.size()) {
            this.ingress.add(builder);
        } else {
            this.ingress.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToIngress(NetworkPolicyIngressRule ... items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList<NetworkPolicyIngressRuleBuilder>();
        }
        for (NetworkPolicyIngressRule item : items) {
            NetworkPolicyIngressRuleBuilder builder = new NetworkPolicyIngressRuleBuilder(item);
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToIngress(Collection<NetworkPolicyIngressRule> items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList<NetworkPolicyIngressRuleBuilder>();
        }
        for (NetworkPolicyIngressRule item : items) {
            NetworkPolicyIngressRuleBuilder builder = new NetworkPolicyIngressRuleBuilder(item);
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromIngress(NetworkPolicyIngressRule ... items) {
        for (NetworkPolicyIngressRule item : items) {
            NetworkPolicyIngressRuleBuilder builder = new NetworkPolicyIngressRuleBuilder(item);
            this._visitables.get("ingress").remove(builder);
            if (this.ingress == null) continue;
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromIngress(Collection<NetworkPolicyIngressRule> items) {
        for (NetworkPolicyIngressRule item : items) {
            NetworkPolicyIngressRuleBuilder builder = new NetworkPolicyIngressRuleBuilder(item);
            this._visitables.get("ingress").remove(builder);
            if (this.ingress == null) continue;
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromIngress(Predicate<NetworkPolicyIngressRuleBuilder> predicate) {
        if (this.ingress == null) {
            return (A)this;
        }
        Iterator<NetworkPolicyIngressRuleBuilder> each = this.ingress.iterator();
        Object visitables = this._visitables.get("ingress");
        while (each.hasNext()) {
            NetworkPolicyIngressRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<NetworkPolicyIngressRule> getIngress() {
        return NetworkPolicySpecFluentImpl.build(this.ingress);
    }

    @Override
    public List<NetworkPolicyIngressRule> buildIngress() {
        return NetworkPolicySpecFluentImpl.build(this.ingress);
    }

    @Override
    public NetworkPolicyIngressRule buildIngress(Integer index) {
        return this.ingress.get(index).build();
    }

    @Override
    public NetworkPolicyIngressRule buildFirstIngress() {
        return this.ingress.get(0).build();
    }

    @Override
    public NetworkPolicyIngressRule buildLastIngress() {
        return this.ingress.get(this.ingress.size() - 1).build();
    }

    @Override
    public NetworkPolicyIngressRule buildMatchingIngress(Predicate<NetworkPolicyIngressRuleBuilder> predicate) {
        for (NetworkPolicyIngressRuleBuilder item : this.ingress) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingIngress(Predicate<NetworkPolicyIngressRuleBuilder> predicate) {
        for (NetworkPolicyIngressRuleBuilder item : this.ingress) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withIngress(List<NetworkPolicyIngressRule> ingress) {
        if (this.ingress != null) {
            this._visitables.get("ingress").removeAll(this.ingress);
        }
        if (ingress != null) {
            this.ingress = new ArrayList<NetworkPolicyIngressRuleBuilder>();
            for (NetworkPolicyIngressRule item : ingress) {
                this.addToIngress(item);
            }
        } else {
            this.ingress = null;
        }
        return (A)this;
    }

    @Override
    public A withIngress(NetworkPolicyIngressRule ... ingress) {
        if (this.ingress != null) {
            this.ingress.clear();
        }
        if (ingress != null) {
            for (NetworkPolicyIngressRule item : ingress) {
                this.addToIngress(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasIngress() {
        return this.ingress != null && !this.ingress.isEmpty();
    }

    @Override
    public NetworkPolicySpecFluent.IngressNested<A> addNewIngress() {
        return new IngressNestedImpl();
    }

    @Override
    public NetworkPolicySpecFluent.IngressNested<A> addNewIngressLike(NetworkPolicyIngressRule item) {
        return new IngressNestedImpl(-1, item);
    }

    @Override
    public NetworkPolicySpecFluent.IngressNested<A> setNewIngressLike(Integer index, NetworkPolicyIngressRule item) {
        return new IngressNestedImpl(index, item);
    }

    @Override
    public NetworkPolicySpecFluent.IngressNested<A> editIngress(Integer index) {
        if (this.ingress.size() <= index) {
            throw new RuntimeException("Can't edit ingress. Index exceeds size.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    public NetworkPolicySpecFluent.IngressNested<A> editFirstIngress() {
        if (this.ingress.size() == 0) {
            throw new RuntimeException("Can't edit first ingress. The list is empty.");
        }
        return this.setNewIngressLike(0, this.buildIngress(0));
    }

    @Override
    public NetworkPolicySpecFluent.IngressNested<A> editLastIngress() {
        int index = this.ingress.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ingress. The list is empty.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    public NetworkPolicySpecFluent.IngressNested<A> editMatchingIngress(Predicate<NetworkPolicyIngressRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ingress.size(); ++i) {
            if (!predicate.test(this.ingress.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ingress. No match found.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    @Deprecated
    public LabelSelector getPodSelector() {
        return this.podSelector != null ? this.podSelector.build() : null;
    }

    @Override
    public LabelSelector buildPodSelector() {
        return this.podSelector != null ? this.podSelector.build() : null;
    }

    @Override
    public A withPodSelector(LabelSelector podSelector) {
        this._visitables.get("podSelector").remove(this.podSelector);
        if (podSelector != null) {
            this.podSelector = new LabelSelectorBuilder(podSelector);
            this._visitables.get("podSelector").add(this.podSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPodSelector() {
        return this.podSelector != null;
    }

    @Override
    public NetworkPolicySpecFluent.PodSelectorNested<A> withNewPodSelector() {
        return new PodSelectorNestedImpl();
    }

    @Override
    public NetworkPolicySpecFluent.PodSelectorNested<A> withNewPodSelectorLike(LabelSelector item) {
        return new PodSelectorNestedImpl(item);
    }

    @Override
    public NetworkPolicySpecFluent.PodSelectorNested<A> editPodSelector() {
        return this.withNewPodSelectorLike(this.getPodSelector());
    }

    @Override
    public NetworkPolicySpecFluent.PodSelectorNested<A> editOrNewPodSelector() {
        return this.withNewPodSelectorLike(this.getPodSelector() != null ? this.getPodSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public NetworkPolicySpecFluent.PodSelectorNested<A> editOrNewPodSelectorLike(LabelSelector item) {
        return this.withNewPodSelectorLike(this.getPodSelector() != null ? this.getPodSelector() : item);
    }

    @Override
    public A addToPolicyTypes(Integer index, String item) {
        if (this.policyTypes == null) {
            this.policyTypes = new ArrayList<String>();
        }
        this.policyTypes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToPolicyTypes(Integer index, String item) {
        if (this.policyTypes == null) {
            this.policyTypes = new ArrayList<String>();
        }
        this.policyTypes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToPolicyTypes(String ... items) {
        if (this.policyTypes == null) {
            this.policyTypes = new ArrayList<String>();
        }
        for (String item : items) {
            this.policyTypes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToPolicyTypes(Collection<String> items) {
        if (this.policyTypes == null) {
            this.policyTypes = new ArrayList<String>();
        }
        for (String item : items) {
            this.policyTypes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromPolicyTypes(String ... items) {
        for (String item : items) {
            if (this.policyTypes == null) continue;
            this.policyTypes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPolicyTypes(Collection<String> items) {
        for (String item : items) {
            if (this.policyTypes == null) continue;
            this.policyTypes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getPolicyTypes() {
        return this.policyTypes;
    }

    @Override
    public String getPolicyType(Integer index) {
        return this.policyTypes.get(index);
    }

    @Override
    public String getFirstPolicyType() {
        return this.policyTypes.get(0);
    }

    @Override
    public String getLastPolicyType() {
        return this.policyTypes.get(this.policyTypes.size() - 1);
    }

    @Override
    public String getMatchingPolicyType(Predicate<String> predicate) {
        for (String item : this.policyTypes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPolicyType(Predicate<String> predicate) {
        for (String item : this.policyTypes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPolicyTypes(List<String> policyTypes) {
        if (policyTypes != null) {
            this.policyTypes = new ArrayList<String>();
            for (String item : policyTypes) {
                this.addToPolicyTypes(item);
            }
        } else {
            this.policyTypes = null;
        }
        return (A)this;
    }

    @Override
    public A withPolicyTypes(String ... policyTypes) {
        if (this.policyTypes != null) {
            this.policyTypes.clear();
        }
        if (policyTypes != null) {
            for (String item : policyTypes) {
                this.addToPolicyTypes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPolicyTypes() {
        return this.policyTypes != null && !this.policyTypes.isEmpty();
    }

    @Override
    public A addNewPolicyType(String arg0) {
        return this.addToPolicyTypes(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkPolicySpecFluentImpl that = (NetworkPolicySpecFluentImpl)o;
        if (this.egress != null ? !this.egress.equals(that.egress) : that.egress != null) {
            return false;
        }
        if (this.ingress != null ? !this.ingress.equals(that.ingress) : that.ingress != null) {
            return false;
        }
        if (this.podSelector != null ? !this.podSelector.equals(that.podSelector) : that.podSelector != null) {
            return false;
        }
        if (this.policyTypes != null ? !this.policyTypes.equals(that.policyTypes) : that.policyTypes != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.egress, this.ingress, this.podSelector, this.policyTypes, this.additionalProperties, super.hashCode());
    }

    public class PodSelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<NetworkPolicySpecFluent.PodSelectorNested<N>>
    implements NetworkPolicySpecFluent.PodSelectorNested<N>,
    Nested<N> {
        LabelSelectorBuilder builder;

        PodSelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        PodSelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkPolicySpecFluentImpl.this.withPodSelector(this.builder.build());
        }

        @Override
        public N endPodSelector() {
            return this.and();
        }
    }

    public class IngressNestedImpl<N>
    extends NetworkPolicyIngressRuleFluentImpl<NetworkPolicySpecFluent.IngressNested<N>>
    implements NetworkPolicySpecFluent.IngressNested<N>,
    Nested<N> {
        NetworkPolicyIngressRuleBuilder builder;
        Integer index;

        IngressNestedImpl(Integer index, NetworkPolicyIngressRule item) {
            this.index = index;
            this.builder = new NetworkPolicyIngressRuleBuilder(this, item);
        }

        IngressNestedImpl() {
            this.index = -1;
            this.builder = new NetworkPolicyIngressRuleBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkPolicySpecFluentImpl.this.setToIngress(this.index, this.builder.build());
        }

        @Override
        public N endIngress() {
            return this.and();
        }
    }

    public class EgressNestedImpl<N>
    extends NetworkPolicyEgressRuleFluentImpl<NetworkPolicySpecFluent.EgressNested<N>>
    implements NetworkPolicySpecFluent.EgressNested<N>,
    Nested<N> {
        NetworkPolicyEgressRuleBuilder builder;
        Integer index;

        EgressNestedImpl(Integer index, NetworkPolicyEgressRule item) {
            this.index = index;
            this.builder = new NetworkPolicyEgressRuleBuilder(this, item);
        }

        EgressNestedImpl() {
            this.index = -1;
            this.builder = new NetworkPolicyEgressRuleBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkPolicySpecFluentImpl.this.setToEgress(this.index, this.builder.build());
        }

        @Override
        public N endEgress() {
            return this.and();
        }
    }
}

