/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.APIService;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.APIServiceList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Binding;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ComponentStatus;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ComponentStatusList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ConfigMap;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ConfigMapList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Endpoints;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.EndpointsList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.GenericKubernetesResourceList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.HasMetadata;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.KubernetesResourceList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.LimitRange;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.LimitRangeList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Namespace;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.NamespaceList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Node;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.NodeList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PersistentVolume;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PersistentVolumeClaimList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PersistentVolumeList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Pod;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ReplicationController;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ReplicationControllerList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ResourceQuota;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ResourceQuotaList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Secret;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.SecretList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Service;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ServiceAccount;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ServiceAccountList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ServiceList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.Deployment;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.StatefulSet;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.authentication.TokenReview;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.batch.v1.Job;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.batch.v1beta1.CronJob;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequest;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.coordination.v1.Lease;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.coordination.v1.LeaseList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.node.v1beta1.RuntimeClass;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.node.v1beta1.RuntimeClassList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.Adapters;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.AdmissionRegistrationAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.AdmissionRegistrationAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.ApiextensionsAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.AppsAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.AuthorizationAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.AutoscalingAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.BaseClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.BatchAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.CertificatesAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.Client;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.ClientContext;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.Config;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.CustomResource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.DiscoveryAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.EventingAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.ExtensionsAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.FlowControlAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.GenericKubernetesClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.Handlers;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.KubernetesClientException;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.MetricAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.NetworkAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.PolicyAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.RbacAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.SchedulingAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.StorageAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.V1APIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.VersionInfo;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.ApiextensionsAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.AppsAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.AuthorizationAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.AutoscalingAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.BatchAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.CertificatesAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.DiscoveryAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.EventingAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.ExtensionsAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.FlowControlAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.InOutCreateable;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.KubernetesListMixedOperation;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.MetricAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.MixedOperation;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.NetworkAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.PodResource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.PolicyAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.RbacAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.Resource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.SchedulingAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.ServiceResource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.StorageAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.V1APIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperationsImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.KubernetesListOperationsImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.RawCustomResourceOperationsImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.apps.v1.DeploymentOperationsImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.apps.v1.StatefulSetOperationsImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.batch.v1.JobOperationsImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.batch.v1beta1.CronJobOperationsImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.certificates.v1.CertificateSigningRequestOperationsImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.core.v1.BindingOperationsImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.core.v1.ComponentStatusOperationsImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.core.v1.PodOperationsImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.core.v1.ReplicationControllerOperationsImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.core.v1.ServiceOperationsImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.extensions.v1beta1.ReplicaSetOperationsImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.extended.run.RunConfigBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.extended.run.RunOperations;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.HttpClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.informers.SharedInformerFactory;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.Serialization;

public abstract class BaseKubernetesClient<C extends Client>
extends BaseClient
implements GenericKubernetesClient<C> {
    public static final String KUBERNETES_VERSION_ENDPOINT = "version";

    protected BaseKubernetesClient() {
    }

    protected BaseKubernetesClient(String masterUrl) {
        super(masterUrl);
    }

    protected BaseKubernetesClient(Config config) {
        super(config);
    }

    protected BaseKubernetesClient(HttpClient httpClient, Config config) {
        super(httpClient, config);
    }

    protected BaseKubernetesClient(ClientContext clientContext) {
        super(clientContext);
    }

    @Override
    public NonNamespaceOperation<ComponentStatus, ComponentStatusList, Resource<ComponentStatus>> componentstatuses() {
        return new ComponentStatusOperationsImpl(this);
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> load(InputStream is) {
        return this.resourceListFor(is);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(KubernetesResourceList item) {
        return this.resourceListFor(item);
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl resourceListFor(Object item) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this, item);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(HasMetadata ... items) {
        return this.resourceList(((KubernetesListBuilder)new KubernetesListBuilder().withItems(items)).build());
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(Collection<HasMetadata> items) {
        return this.resourceList(((KubernetesListBuilder)new KubernetesListBuilder().withItems(new ArrayList<HasMetadata>(items))).build());
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(String s) {
        return this.resourceListFor(s);
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata> resource(HasMetadata item) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this, item);
    }

    @Override
    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata> resource(String s) {
        return this.resource((HasMetadata)Serialization.unmarshal(s));
    }

    @Override
    public MixedOperation<Binding, KubernetesResourceList<Binding>, Resource<Binding>> bindings() {
        return new BindingOperationsImpl(this);
    }

    @Override
    public MixedOperation<Endpoints, EndpointsList, Resource<Endpoints>> endpoints() {
        return Handlers.getOperation(Endpoints.class, EndpointsList.class, this);
    }

    @Override
    public NonNamespaceOperation<Namespace, NamespaceList, Resource<Namespace>> namespaces() {
        return Handlers.getOperation(Namespace.class, NamespaceList.class, this);
    }

    @Override
    public NonNamespaceOperation<Node, NodeList, Resource<Node>> nodes() {
        return Handlers.getOperation(Node.class, NodeList.class, this);
    }

    @Override
    public NonNamespaceOperation<PersistentVolume, PersistentVolumeList, Resource<PersistentVolume>> persistentVolumes() {
        return Handlers.getOperation(PersistentVolume.class, PersistentVolumeList.class, this);
    }

    @Override
    public MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, Resource<PersistentVolumeClaim>> persistentVolumeClaims() {
        return Handlers.getOperation(PersistentVolumeClaim.class, PersistentVolumeClaimList.class, this);
    }

    @Override
    public MixedOperation<Pod, PodList, PodResource<Pod>> pods() {
        return new PodOperationsImpl(this);
    }

    @Override
    public MixedOperation<ReplicationController, ReplicationControllerList, RollableScalableResource<ReplicationController>> replicationControllers() {
        return new ReplicationControllerOperationsImpl(this);
    }

    @Override
    public MixedOperation<ResourceQuota, ResourceQuotaList, Resource<ResourceQuota>> resourceQuotas() {
        return Handlers.getOperation(ResourceQuota.class, ResourceQuotaList.class, this);
    }

    @Override
    public SchedulingAPIGroupDSL scheduling() {
        return this.adapt(SchedulingAPIGroupClient.class);
    }

    @Override
    public MixedOperation<Secret, SecretList, Resource<Secret>> secrets() {
        return Handlers.getOperation(Secret.class, SecretList.class, this);
    }

    @Override
    public MixedOperation<Service, ServiceList, ServiceResource<Service>> services() {
        return new ServiceOperationsImpl(this);
    }

    @Override
    public MixedOperation<ServiceAccount, ServiceAccountList, Resource<ServiceAccount>> serviceAccounts() {
        return Handlers.getOperation(ServiceAccount.class, ServiceAccountList.class, this);
    }

    @Override
    public NonNamespaceOperation<APIService, APIServiceList, Resource<APIService>> apiServices() {
        return Handlers.getOperation(APIService.class, APIServiceList.class, this);
    }

    @Override
    public KubernetesListMixedOperation lists() {
        return new KubernetesListOperationsImpl(this);
    }

    @Override
    public MixedOperation<ConfigMap, ConfigMapList, Resource<ConfigMap>> configMaps() {
        return Handlers.getOperation(ConfigMap.class, ConfigMapList.class, this);
    }

    @Override
    public MixedOperation<LimitRange, LimitRangeList, Resource<LimitRange>> limitRanges() {
        return Handlers.getOperation(LimitRange.class, LimitRangeList.class, this);
    }

    @Override
    public ApiextensionsAPIGroupDSL apiextensions() {
        return this.adapt(ApiextensionsAPIGroupClient.class);
    }

    @Override
    public NonNamespaceOperation<org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequest, CertificateSigningRequestList, Resource<org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequest>> certificateSigningRequests() {
        return Handlers.getOperation(org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequest.class, CertificateSigningRequestList.class, this);
    }

    @Override
    public CertificatesAPIGroupDSL certificates() {
        return this.adapt(CertificatesAPIGroupClient.class);
    }

    @Override
    public AuthorizationAPIGroupDSL authorization() {
        return this.adapt(AuthorizationAPIGroupClient.class);
    }

    @Override
    public InOutCreateable<TokenReview, TokenReview> tokenReviews() {
        return Handlers.getNonListingOperation(TokenReview.class, this);
    }

    @Override
    public <T extends CustomResource> MixedOperation<T, KubernetesResourceList<T>, Resource<T>> customResources(Class<T> resourceType) {
        return this.customResources(resourceType, null);
    }

    @Override
    public <T extends CustomResource, L extends KubernetesResourceList<T>> MixedOperation<T, L, Resource<T>> customResources(Class<T> resourceType, Class<L> listClass) {
        return this.customResources((ResourceDefinitionContext)CustomResourceDefinitionContext.fromCustomResourceType(resourceType), (Class)resourceType, (Class)listClass);
    }

    @Override
    public MixedOperation<GenericKubernetesResource, GenericKubernetesResourceList, Resource<GenericKubernetesResource>> genericKubernetesResources(String apiVersion, String kind) {
        ResourceDefinitionContext context = Handlers.getResourceDefinitionContext(apiVersion, kind, this);
        if (context == null) {
            throw new KubernetesClientException("Could not find the metadata for the given apiVersion and kind, please pass a ResourceDefinitionContext instead");
        }
        return this.genericKubernetesResources(context);
    }

    public <T extends HasMetadata, L extends KubernetesResourceList<T>> HasMetadataOperation<T, L, Resource<T>> resources(Class<T> resourceType, Class<L> listClass) {
        try {
            return Handlers.getOperation(resourceType, listClass, this);
        }
        catch (Exception e) {
            return this.customResources(ResourceDefinitionContext.fromResourceType(resourceType), (Class)resourceType, (Class)listClass);
        }
    }

    public <T extends HasMetadata, L extends KubernetesResourceList<T>> HasMetadataOperationsImpl<T, L> customResources(ResourceDefinitionContext rdContext, Class<T> resourceType, Class<L> listClass) {
        return new HasMetadataOperationsImpl<T, L>(this, rdContext, resourceType, listClass);
    }

    @Override
    public RawCustomResourceOperationsImpl customResource(CustomResourceDefinitionContext customResourceDefinition) {
        return new RawCustomResourceOperationsImpl(this, customResourceDefinition);
    }

    @Override
    public DiscoveryAPIGroupDSL discovery() {
        return this.adapt(DiscoveryAPIGroupClient.class);
    }

    @Override
    public EventingAPIGroupDSL events() {
        return this.adapt(EventingAPIGroupClient.class);
    }

    @Override
    public C inAnyNamespace() {
        return (C)((Client)this.inNamespace(null));
    }

    @Override
    public ExtensionsAPIGroupDSL extensions() {
        return this.adapt(ExtensionsAPIGroupClient.class);
    }

    @Override
    public FlowControlAPIGroupDSL flowControl() {
        return this.adapt(FlowControlAPIGroupClient.class);
    }

    @Override
    public VersionInfo getVersion() {
        return this.getVersionInfo(KUBERNETES_VERSION_ENDPOINT);
    }

    @Override
    public VersionInfo getKubernetesVersion() {
        return this.getVersionInfo(KUBERNETES_VERSION_ENDPOINT);
    }

    @Override
    public V1APIGroupDSL v1() {
        return this.adapt(V1APIGroupClient.class);
    }

    @Override
    public AdmissionRegistrationAPIGroupDSL admissionRegistration() {
        return this.adapt(AdmissionRegistrationAPIGroupClient.class);
    }

    @Override
    public AppsAPIGroupDSL apps() {
        return this.adapt(AppsAPIGroupClient.class);
    }

    @Override
    public AutoscalingAPIGroupDSL autoscaling() {
        return this.adapt(AutoscalingAPIGroupClient.class);
    }

    @Override
    public NetworkAPIGroupDSL network() {
        return this.adapt(NetworkAPIGroupClient.class);
    }

    @Override
    public StorageAPIGroupDSL storage() {
        return this.adapt(StorageAPIGroupClient.class);
    }

    @Override
    public BatchAPIGroupDSL batch() {
        return this.adapt(BatchAPIGroupClient.class);
    }

    @Override
    public MetricAPIGroupDSL top() {
        return this.adapt(MetricAPIGroupClient.class);
    }

    @Override
    public PolicyAPIGroupDSL policy() {
        return this.adapt(PolicyAPIGroupClient.class);
    }

    @Override
    public RbacAPIGroupDSL rbac() {
        return this.adapt(RbacAPIGroupClient.class);
    }

    @Override
    public SharedInformerFactory informers() {
        return new SharedInformerFactory(this);
    }

    @Override
    public SharedInformerFactory informers(ExecutorService executorService) {
        return new SharedInformerFactory(this, executorService);
    }

    @Override
    public MixedOperation<Lease, LeaseList, Resource<Lease>> leases() {
        return Handlers.getOperation(Lease.class, LeaseList.class, this);
    }

    @Override
    public RunOperations run() {
        return new RunOperations(this, this.getNamespace(), new RunConfigBuilder());
    }

    @Override
    public NonNamespaceOperation<RuntimeClass, RuntimeClassList, Resource<RuntimeClass>> runtimeClasses() {
        return Handlers.getOperation(RuntimeClass.class, RuntimeClassList.class, this);
    }

    static {
        Handlers.register(Pod.class, PodOperationsImpl::new);
        Handlers.register(Job.class, JobOperationsImpl::new);
        Handlers.register(CronJob.class, CronJobOperationsImpl::new);
        Handlers.register(Binding.class, BindingOperationsImpl::new);
        Handlers.register(ComponentStatus.class, ComponentStatusOperationsImpl::new);
        Handlers.register(Service.class, ServiceOperationsImpl::new);
        Handlers.register(Deployment.class, DeploymentOperationsImpl::new);
        Handlers.register(org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.extensions.Deployment.class, org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.extensions.v1beta1.DeploymentOperationsImpl::new);
        Handlers.register(ReplicaSet.class, org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.apps.v1.ReplicaSetOperationsImpl::new);
        Handlers.register(org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.extensions.ReplicaSet.class, ReplicaSetOperationsImpl::new);
        Handlers.register(ReplicationController.class, ReplicationControllerOperationsImpl::new);
        Handlers.register(StatefulSet.class, StatefulSetOperationsImpl::new);
        Handlers.register(CertificateSigningRequest.class, CertificateSigningRequestOperationsImpl::new);
        Adapters.list(Client.class);
    }
}

