/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal;

import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.HasMetadata;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.KubernetesResource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.KubernetesResourceList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.ClientContext;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.Config;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.MixedOperation;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.Resource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.base.OperationContext;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.internal.KubernetesDeserializer;

public class HasMetadataOperationsImpl<T extends HasMetadata, L extends KubernetesResourceList<T>>
extends HasMetadataOperation<T, L, Resource<T>>
implements MixedOperation<T, L, Resource<T>> {
    private final ResourceDefinitionContext rdc;

    public HasMetadataOperationsImpl(ClientContext clientContext, ResourceDefinitionContext rdc, Class<T> type, Class<L> listType) {
        this(HasMetadataOperationsImpl.defaultContext(clientContext), rdc, type, listType);
    }

    public static OperationContext defaultContext(OperationContext context, ClientContext clientContext) {
        return context.withHttpClient(clientContext.getHttpClient()).withConfig((Config)clientContext.getConfiguration()).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY);
    }

    public static OperationContext defaultContext(ClientContext clientContext) {
        return HasMetadataOperationsImpl.defaultContext(new OperationContext(), clientContext);
    }

    public HasMetadataOperationsImpl(OperationContext context, ResourceDefinitionContext rdc, Class<T> type, Class<L> listType) {
        super(context.withApiGroupName(rdc.getGroup()).withApiGroupVersion(rdc.getVersion()).withPlural(rdc.getPlural()), type, listType != null ? listType : KubernetesResourceUtil.inferListType(type));
        this.rdc = rdc;
        this.apiGroupName = rdc.getGroup();
        this.apiGroupVersion = rdc.getVersion();
        this.apiVersion = ApiVersionUtil.joinApiGroupAndVersion(this.getAPIGroupName(), this.getAPIGroupVersion());
        if (!GenericKubernetesResource.class.isAssignableFrom(type)) {
            KubernetesDeserializer.registerCustomKind(this.apiVersion, this.kind(rdc), type);
            if (KubernetesResource.class.isAssignableFrom(this.listType)) {
                KubernetesDeserializer.registerCustomKind(this.listType.getSimpleName(), this.listType);
            }
        }
    }

    @Override
    protected void validateOperation(Class<T> type) {
    }

    public HasMetadataOperationsImpl<T, L> newInstance(OperationContext context) {
        return new HasMetadataOperationsImpl<T, L>(context, this.rdc, this.type, this.listType);
    }

    private String kind(ResourceDefinitionContext context) {
        return context.getKind() != null ? context.getKind() : this.getKind();
    }

    @Override
    public boolean isResourceNamespaced() {
        return this.rdc.isNamespaceScoped();
    }

    public OperationContext getOperationContext() {
        return this.context;
    }
}

