/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http;

import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.BasicBuilder;

public interface WebSocket {
    public boolean send(ByteBuffer var1);

    public boolean sendClose(int var1, String var2);

    public long queueSize();

    public static interface Builder
    extends BasicBuilder {
        public CompletableFuture<WebSocket> buildAsync(Listener var1);

        @Override
        public Builder header(String var1, String var2);

        @Override
        public Builder setHeader(String var1, String var2);

        @Override
        public Builder uri(URI var1);
    }

    public static interface Listener {
        default public void onOpen(WebSocket webSocket) {
        }

        default public void onMessage(WebSocket webSocket, String text) {
        }

        default public void onMessage(WebSocket webSocket, ByteBuffer bytes) {
        }

        default public void onClose(WebSocket webSocket, int code, String reason) {
        }

        default public void onError(WebSocket webSocket, Throwable error) {
        }
    }
}

