/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.informers.cache;

import java.util.List;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.informers.cache.Indexer;

public class Lister<T> {
    private String namespace;
    private String indexName;
    private Indexer<T> indexer;

    public Lister(Indexer<T> indexer) {
        this(indexer, null, "namespace");
    }

    public Lister(Indexer<T> indexer, String namespace) {
        this(indexer, namespace, "namespace");
    }

    public Lister(Indexer<T> indexer, String namespace, String indexName) {
        this.indexer = indexer;
        this.namespace = namespace;
        this.indexName = indexName;
    }

    public List<T> list() {
        if (this.namespace == null || this.namespace.isEmpty()) {
            return this.indexer.list();
        }
        return this.indexer.byIndex(this.indexName, this.namespace);
    }

    public T get(String name) {
        String key = name;
        if (this.namespace != null && !this.namespace.isEmpty()) {
            key = this.namespace + "/" + name;
        }
        return this.indexer.getByKey(key);
    }

    public Lister<T> namespace(String namespace) {
        return new Lister<T>(this.indexer, namespace, "namespace");
    }
}

